package com.bxm.adxcounter.facade.model;

import java.io.Serializable;

import com.bxm.warcar.validate.annotation.ValidateNotNull;

import lombok.Data;

/**
 * SDK错误信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/4/8 11:51
 */
@Data
public class SdkErrorDTO implements Serializable {

    private static final long serialVersionUID = 1132577199900938728L;

    /**
     * SDK版本号
     */
    @ValidateNotNull
    private String version;
    /**
     * 手机型号
     */
    @ValidateNotNull
    private String devm;
    /**
     * 操作系统
     * 1：安卓，2：IOS
     */
    @ValidateNotNull
    private Integer os;
    /**
     * 操作系统版本号
     */
    @ValidateNotNull
    private String osv;
    /**
     * 广告位ID
     */
    private String positionId;
    /**
     * 错误信息
     */
    @ValidateNotNull
    private String errorMsg;
}
