package com.bxm.adxcounter.facade.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * SDK初始化上报信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/1/11 15:54
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SdkEquipmentDTO extends SdkPublicDTO {

    private static final long serialVersionUID = -1L;

    /**
     * 请求时间戳,目前不需要前端传
     */
    private Long timestamp;

    /**
     * mac地址
     */
    private String mac;
    /**
     * 设备id（deviceId）
     */
    private String devid;
    /**
     * 设备品牌（deviceBrand）,如：华为
     */
    private String devb;
    /**
     * 设备型号（deviceModel）,如：华为 mate 10 pro
     */
    private String devm;
    /**
     * 设备类型（deviceType）
     * 1：手机
     * 2：平板
     */
    private String devt;
    /**
     * 设备屏幕高度（screenHeight）
     */
    private Integer devsh;
    /**
     * 设备屏幕宽度（screenWidth）
     */
    private Integer devsw;
    /**
     * 内存,单位：G
     */
    private String memory;
    /**
     * 存储空间,单位：G
     */
    private String storage;
    /**
     * cpu型号（cpuModel）
     */
    private String cpum;
    /**
     * 手机网络运行商
     * 0：未知
     * 1：移动
     * 2：联通
     * 3：电信
     */
    private String isp;
    /**
     * 联网方式（netType）
     * 0:未知
     * 1:以太网
     * 2:Wifi网络
     * 3:蜂窝数据网络-2G
     * 4:蜂窝数据网络-3G
     * 5:蜂窝数据网络-4G
     * 6:蜂窝数据网络-5G
     * 7:蜂窝数据网络-未知
     */
    private String net;
    /**
     * 经度（longitude）
     */
    private String lon;
    /**
     * 纬度（latitude）
     */
    private String lat;
    
    /**
     * sdk版本号，如：1.0.0
     */
    private String sdkv;
    /**
     * 本机应用列表（appList）
     */
    private String appl;
    /**
     * APP包名(packageName)
     */
    private String pkn;
    /**
     * 是否多开APP,true:是
     * @since v3.5.1
     */
    private Boolean isDualApp;
    /**
     * 正常myUid/100000=0，多开APP=999或其他
     * @since v3.5.1
     */
    private Integer myUid;
    /**
     * 1: 模拟器 0：真机
     */
    private Integer isSimulator;
    /**
     * 获取applist超时
     * 0未超时/1超时
     */
    private Integer applto;
}