package com.bxm.adxcounter.facade.model;

import com.google.common.collect.Maps;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

/**
 * @author allen
 * @date 2020-07-16
 * @since 1.0
 */
@Data
public class SdkPublicDTO implements Serializable {
    private static final long serialVersionUID = 8298313397432807668L;

    /**
     * 扩展：APP自定义用户ID
     */
    public static final String EXT_CUID = "cuid";
    /**
     * 扩展：APP自定义用户ID,cuid将继承pcuid的资产
     */
    public static final String EXT_PCUID = "pcuid";


    /**
     * 通过规则从imei/imeiMd5/androidId/androidIdMd5/oaid/idfa/idfaMd5中，获得该值
     */
    private String devUid;
    /**
     * IP地址
     */
    private String ip;
    /**
     * 系统类型
     * 0：未知
     * 1：安卓
     * 2：IOS
     */
    private Integer os;
    /**
     * 系统版本号，如：5.0.0
     */
    private String osv;
    /**
     * IMEI，所属安卓
     */
    private String imei;
    /**
     * IMEI，所属安卓
     */
    private String imei_md5;
    /**
     * 安卓ID
     */
    private String anid;
    /**
     * 安卓ID
     */
    private String anid_md5;
    /**
     * 安全联盟定义的用户唯一标识OAID
     */
    private String oaid;
    /**
     * IDFA，所属IOS
     */
    private String idfa;
    /**
     * IDFA，所属IOS
     */
    private String idfa_md5;

    /**
     * 变现猫appid(Code)
     */
    private String appid;

    /**
     * 扩展数据，使用GET请求参数格式的键值对，以&进行分割，其中的参数值如有特殊符号需要进行urlencode编码。
     * 示例：cuid=1122&oid=8982111
     */
    private String ext;

    public Map<String, String> getExtForMap() {
        if (StringUtils.isBlank(ext)) {
            return null;
        }
        Map<String, String> param = Maps.newHashMap();
        String[] items = StringUtils.split(ext, "&");
        for (String item : items) {
            String[] kv = StringUtils.split(item, "=");
            if (kv.length < 2) {
                continue;
            }
            String key = kv[0], value = kv[1];
            param.put(key, decode(value));
        }
        return param;
    }

    private static String decode(String str) {
        try {
            return URLDecoder.decode(str, StandardCharsets.UTF_8.name());
        } catch (UnsupportedEncodingException e) {
            return str;
        }
    }
}
