package com.bxm.adxcounter.facade.service;

import com.bxm.adxcounter.facade.constant.Constants;
import com.bxm.adxcounter.facade.model.AdxCounterDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * 数据监测-ADX<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 11:06
 */
@FeignClient(Constants.SERVER_NAME)
public interface AdxCounterService {

    /**
     * Adx数据监测<br/>
     *
     * @param counter
     * @return
     */
    @RequestMapping("/adxCounterService/counter")
    ResponseEntity counter(@RequestBody AdxCounterDTO counter);
}
