package com.bxm.adxcounter.facade.model;

import com.bxm.warcar.validate.annotation.ValidateNotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 埋点参数-ADX<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 17:24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class AdxCounterDTO extends AbstractCounterDTO {
    
    private static final long serialVersionUID = -537631479506482834L;
    
    /**
     * 模块类型modelType
     * @see com.bxm.adxcounter.facade.constant.AdxMtEnum#getOriginal()
     */
    @ValidateNotNull
    private Integer mt;
    /**
     * 变现猫竞价ID
     */
    private String bidid;
    /**
     * 广告位ID
     */
    private String tagid;
    /**
     * 广告平台ID
     */
    private String dspid;
    /**
     * 创意ID
     */
    private String createid;
    /**
     * 赢价价格（单位：分）
     */
    private String win;
    /**
     * 状态
     * 1.mt=15003时，需区分竞价成功和失败，且列出具体失败原因；
     * 2.mt=15114时，0 - 正常播放；1 - 视频加载中；2 - 播放错误。
     */
    private String status;
    /**
     * 活动ID
     */
    private String actid;
    /**
     * 投放场景类型
     */
    private String scene;
    /**
     * 点击事件鼠标或手指按下时相对于素材的 X 坐标
     */
    private String x_down;
    /**
     * 点击事件鼠标或手指按下时相对于素材的 Y坐标
     */
    private String y_down;
    /**
     * 点击事件鼠标或手指弹起时相对于素材的 X 坐标
     */
    private String x_up;
    /**
     * 点击事件鼠标或手指弹起时相对于素材的 Y 坐标
     */
    private String y_up;
    /**
     * 广告请求中的广告位宽，单位像素
     */
    private String reqpw;
    /**
     * 广告请求中的广告位高，单位像素
     */
    private String reqph;
    /**
     * 实际广告位的宽，单位像素
     */
    private String actpw;
    /**
     * 实际广告位的高，单位像素
     */
    private String actph;
    /**
     * 视频总时长,单位秒
     */
    private String vi_duration;
    /**
     * 流量分桶实验id
     */
    private String experimentid;
    /**
     * 场景链接标识id
     */
    private String stid;
    /**
     * 广告主id
     */
    private String avtsid;
    /**
     * 视频点击位置
     */
    private String ce_type;
}
