package com.bxm.adxcounter.facade.model;

import com.bxm.warcar.validate.annotation.ValidateNotNull;
import lombok.Data;

import java.io.Serializable;

/**
 * SDK错误信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/4/8 11:51
 */
@Data
public class SdkErrorDTO implements Serializable {

    private static final long serialVersionUID = 1132577199900938728L;

    /**
     * SDK版本号
     */
    @ValidateNotNull
    private String version;
    /**
     * 手机型号
     */
    @ValidateNotNull
    private String devm;
    /**
     * 操作系统
     * 1：安卓，2：IOS
     */
    @ValidateNotNull
    private Integer os;
    /**
     * 操作系统版本号
     */
    @ValidateNotNull
    private String osv;
    /**
     * 广告位ID
     */
    private String positionId;
    /**
     * 错误信息
     */
    private String errorMsg;
    /**
     * appId
     * @since 3.5.4
     */
    private String appId;
    /**
     * APP包名
     * @since 3.5.4
     */
    private String pkgName;
    /**
     * 错误类型
     * @since 3.5.4
     */
    private String crashType;
    /**
     * 错误原因
     * @since 3.5.4
     */
    private String crashReason;
    /**
     * 错误控制器 (仅ios)
     * @since 3.5.4
     */
    private String visController;
    /**
     * 错误堆栈日志
     * @since 3.5.4
     */
    private String crashLog;
    /**
     * 错误发生时间
     * @since 3.5.4
     */
    private String crashTime;
    /**
     * APP名称
     * @since 3.5.4
     */
    private String crashAppName;
    /**
     * APP版本
     * @since 3.5.4
     */
    private String crashAppVer;
    /**
     * 内存大小 (仅android)
     * @since 3.5.4
     */
    private String memory;
    /**
     * 存储空间大小 (仅android)
     * @since 3.5.4
     */
    private String storage;
    /**
     * cpu类型 (仅android)
     * @since 3.5.4
     */
    private String cpu;
    /**
     * 是否Sdk错误
     * @since 3.5.4
     */
    private Boolean hasSdkErr;
    /**
     * IMEI，所属安卓
     * @since 3.5.4
     */
    private String imei;
    /**
     * IMEI，所属安卓
     * @since 3.5.4
     */
    private String imei_md5;
    /**
     * 安卓ID
     * @since 3.5.4
     */
    private String anid;
    /**
     * 安卓ID
     * @since 3.5.4
     */
    private String anid_md5;
    /**
     * 安全联盟定义的用户唯一标识OAID
     * @since 3.5.4
     */
    private String oaid;
    /**
     * IDFA，所属IOS
     * @since 3.5.4
     */
    private String idfa;
    /**
     * IDFA，所属IOS
     * @since 3.5.4
     */
    private String idfa_md5;
    /**
     * Google Advertising ID
     */
    private String gaid;
    /**
     * Google Advertising ID
     */
    private String gaid_md5;
}
