package com.bxm.adxcounter.facade.model;

import com.bxm.warcar.validate.annotation.ValidateNotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 埋点参数-耍呗任务<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 17:24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class TaskCounterDTO extends AbstractCounterDTO {
    
    private static final long serialVersionUID = -537631479506482834L;
    
    /**
     * 模块类型modelType
     * @see com.bxm.adxcounter.facade.constant.AdxMtEnum#getOriginal()
     */
    @ValidateNotNull
    private Integer mt;
    /**
     * 变现猫竞价ID
     */
    private String bidid;
    /**
     * 开发者应用appid
     */
    private String appid;
    /**
     * 广告位ID
     */
    private String tagid;
    /**
     * 广告平台ID
     */
    private String dspid;
    /**
     * 任务ID
     */
    private String taskid;

}
