package com.bxm.app.model.ro;

import java.util.Date;

import io.swagger.annotations.ApiModelProperty;

public class AppEntranceAdRo {

    /**
     * 主键id
     */
    @ApiModelProperty(value = "id")
    private Long    id;

    /**
     * appId
     */
    @ApiModelProperty(value = "appId")
    private Integer appId;
    /**
     * appKey
     */
    @ApiModelProperty(value = "appKey")
    private String  appKey;
    /**
     * app名称
     */
    @ApiModelProperty(value = "app名称")
    private String  appName;

    /**
     * app入口名称(开发者配置)
     */
    @ApiModelProperty(value = "app入口名称(开发者配置)")
    private String  appEntranceName;

    /**
     * app入口id(开发者配置)
     */
    @ApiModelProperty(value = "app入口id(开发者配置)")
    private String  appEntranceId;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String  remark;

    /**
     * 别名
     */
    @ApiModelProperty(value = "别名")
    private String  alias;

    /**
     * 广告位id标识
     */
    @ApiModelProperty(value = "广告位id标识")
    private String  positionId;

    /**
     * 媒体类型
     */
    @ApiModelProperty(value = " 媒体类型")
    private String  mediaType;

    /**
     * 媒体分类
     */
    @ApiModelProperty(value = "媒体分类")
    private String  mediaClass;

    /**
     * 媒体子分类
     */
    @ApiModelProperty(value = "媒体子分类")
    private String  mediaChildClass;

    /**
     * 对接方式：0获取链接,1JS对接,2API对接，默认0
     */
    @ApiModelProperty(value = "对接方式：0获取链接,1JS对接,2API对接，默认0")
    private Integer dockingMethod;

    /**
     * 素材图片尺寸
     */
    @ApiModelProperty(value = "素材图片尺寸")
    private String  imageSize;

    /**
     * 广告位状态：0审核中,1已通过,2已拒绝，默认0
     */
    @ApiModelProperty(value = "广告位状态：0审核中,1已通过,2已拒绝，默认0")
    private Integer state;

    /**
     * 审核不通过原因
     */
    @ApiModelProperty(value = "审核不通过原因")
    private String  refuseReason;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date    created;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    private Date    modified;

    /**
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the appId
     */
    public Integer getAppId() {
        return appId;
    }

    /**
     * @param appId the appId to set
     */
    public void setAppId(Integer appId) {
        this.appId = appId;
    }

    /**
     * @return the appKey
     */
    public String getAppKey() {
        return appKey;
    }

    /**
     * @param appKey the appKey to set
     */
    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    /**
     * @return the appName
     */
    public String getAppName() {
        return appName;
    }

    /**
     * @param appName the appName to set
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * @return the appEntranceName
     */
    public String getAppEntranceName() {
        return appEntranceName;
    }

    /**
     * @param appEntranceName the appEntranceName to set
     */
    public void setAppEntranceName(String appEntranceName) {
        this.appEntranceName = appEntranceName;
    }

    /**
     * @return the appEntranceId
     */
    public String getAppEntranceId() {
        return appEntranceId;
    }

    /**
     * @param appEntranceId the appEntranceId to set
     */
    public void setAppEntranceId(String appEntranceId) {
        this.appEntranceId = appEntranceId;
    }

    /**
     * @return the remark
     */
    public String getRemark() {
        return remark;
    }

    /**
     * @param remark the remark to set
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * @return the alias
     */
    public String getAlias() {
        return alias;
    }

    /**
     * @param alias the alias to set
     */
    public void setAlias(String alias) {
        this.alias = alias;
    }

    /**
     * @return the positionId
     */
    public String getPositionId() {
        return positionId;
    }

    /**
     * @param positionId the positionId to set
     */
    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    /**
     * @return the mediaType
     */
    public String getMediaType() {
        return mediaType;
    }

    /**
     * @param mediaType the mediaType to set
     */
    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    /**
     * @return the mediaClass
     */
    public String getMediaClass() {
        return mediaClass;
    }

    /**
     * @param mediaClass the mediaClass to set
     */
    public void setMediaClass(String mediaClass) {
        this.mediaClass = mediaClass;
    }

    /**
     * @return the mediaChildClass
     */
    public String getMediaChildClass() {
        return mediaChildClass;
    }

    /**
     * @param mediaChildClass the mediaChildClass to set
     */
    public void setMediaChildClass(String mediaChildClass) {
        this.mediaChildClass = mediaChildClass;
    }

    /**
     * @return the dockingMethod
     */
    public Integer getDockingMethod() {
        return dockingMethod;
    }

    /**
     * @param dockingMethod the dockingMethod to set
     */
    public void setDockingMethod(Integer dockingMethod) {
        this.dockingMethod = dockingMethod;
    }

    /**
     * @return the imageSize
     */
    public String getImageSize() {
        return imageSize;
    }

    /**
     * @param imageSize the imageSize to set
     */
    public void setImageSize(String imageSize) {
        this.imageSize = imageSize;
    }

    /**
     * @return the state
     */
    public Integer getState() {
        return state;
    }

    /**
     * @param state the state to set
     */
    public void setState(Integer state) {
        this.state = state;
    }

    /**
     * @return the refuseReason
     */
    public String getRefuseReason() {
        return refuseReason;
    }

    /**
     * @param refuseReason the refuseReason to set
     */
    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason;
    }

    /**
     * @return the created
     */
    public Date getCreated() {
        return created;
    }

    /**
     * @param created the created to set
     */
    public void setCreated(Date created) {
        this.created = created;
    }

    /**
     * @return the modified
     */
    public Date getModified() {
        return modified;
    }

    /**
     * @param modified the modified to set
     */
    public void setModified(Date modified) {
        this.modified = modified;
    }

}
