package com.bxm.dspams.controller.base;

import com.bxm.acl.facade.AclAuthInterceptor;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.warcar.utils.IpHelper;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 辅助型基类<br/>
 *
 * @author pf.w
 */
@Slf4j
public abstract class HelperBaseController {

    public UserVo getUser(HttpServletRequest request, HttpServletResponse response){
        return getUser(request);
    }

    /**
     * 获取用户信息<br/>
     */
    public UserVo getUser(HttpServletRequest request){
        UserVo user = null;
        try {
            Object object = request.getAttribute(AclAuthInterceptor.USER_KEY);
            if(null == object){
                user = new UserVo();
            }else{
                user = (UserVo)object;
            }
        }catch (Exception e){
            user = new UserVo();
            log.error(e.getMessage(),e);
        }
        user.setIp(IpHelper.getIpFromHeader(request));
        return user;
    }

}