package com.bxm.dspams.controller.base;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.dspams.common.model.base.BaseEntity;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.springframework.http.ResponseEntity;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * 无注解的前端控制器基类<br/>
 *
 * @author pf.w
 */
@Slf4j
public abstract class WithoutAnnotationBaseController<T extends BaseEntity> extends HelperBaseController {

    protected abstract IService<T> getService();

    public ResponseEntity<T> post(T t) {
        if (getService().save(t)) {
            return ResponseEntity.ok(t);
        } else {
            return ResponseEntity.badRequest().build();
        }
    }

    public ResponseEntity<T> put(T t) {
        if (getService().updateById(t)) {
            return ResponseEntity.ok(t);
        } else {
            return ResponseEntity.badRequest().build();
        }
    }

    public ResponseEntity<Boolean> delete(Long id) {
        if (getService().removeById(id)) {
            return ResponseEntity.ok(true);
        } else {
            return ResponseEntity.badRequest().build();
        }
    }

    protected ResponseEntity<Boolean> logicDelete(Long id) {
        IService<T> service = getService();
        T t = service.getById(id);
        if (null == t) {
            return ResponseEntity.ok(false);
        }
        try {
            MethodUtils.invokeMethod(t, "setDeleted", Constants.YES);
        } catch (NoSuchMethodException | InvocationTargetException | IllegalAccessException ex) {
            log.error("logicDelete: ", ex);
            return ResponseEntity.badRequest().body(false);
        }
        return ResponseEntity.ok(service.updateById(t));
    }

    public ResponseEntity<T> get(Long id) {
        return ResponseEntity.ok(getService().getById(id));
    }

    public ResponseEntity<List<T>> list(Page page, T query) {
        QueryWrapper<T> wrappers = Wrappers.query(query);
        List<OrderItem> orders = page.getOrders();
        if(CollectionUtils.isEmpty(orders)){
            wrappers.orderByDesc("id");
        }else{
            orders.forEach(o -> {
                if(o.isAsc()){
                    wrappers.orderByAsc(o.getColumn());
                }else{
                    wrappers.orderByDesc(o.getColumn());
                }
            });
        }
        return ResponseEntity.ok(getService().list(Wrappers.query(query)));
    }

    public ResponseEntity<IPage<T>> page(Page<T> page, T query) {
        if(CollectionUtils.isEmpty(page.getOrders())){
            page.setOrders(Lists.newArrayList(OrderItem.desc("id")));
        }
        return ResponseEntity.ok(getService().page(page, Wrappers.query(query)));
    }
}