package com.bxm.dspams.controller.sysDictionary;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.dspams.common.core.entity.SystemDictionaryEntity;
import com.bxm.dspams.common.core.service.ISystemDictionaryService;
import com.bxm.dspams.common.model.sysDictionary.SystemDictionaryVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.bxm.dspams.controller.base.BaseController;

/**
 * <p>
 * 系统字典
 * </p>
 *
 * @author jingyu.li
 * @since 2023-02-24
 */
@RestController
@RequestMapping("/systemDictionary")
public class SystemDictionaryController extends BaseController<SystemDictionaryEntity> {

    @Autowired
    private ISystemDictionaryService iSystemDictionaryService;

    @Override
    protected IService<SystemDictionaryEntity> getService() {
        return iSystemDictionaryService;
    }

    /**
     * 查询字典或子类型管理列表
     * @param keyword 字典名称
     * @param pageNum 第几页，默认1
     * @param pageSize 每页条数。默认20
     * @return
     */
    @RequestMapping(value = "/getPage",method = RequestMethod.GET)
    public ResponseEntity<IPage<SystemDictionaryVO>> getPage(@RequestParam(value = "pid",defaultValue = "0")String pid,
                                                          @RequestParam(value = "keyword",required = false)String keyword,
                                                          @RequestParam(value = "pageNum",defaultValue = "1")Integer pageNum,
                                                          @RequestParam( value = "pageSize",defaultValue = "20")Integer pageSize) {
        return ResponseEntity.ok().body(iSystemDictionaryService.getPage(keyword,pid,pageNum,pageSize));
    }
}
