/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.autoconfigure.distributed;

import com.bxm.warcar.integration.autoconfigure.distributed.DistributedScheduledAutoConfiguration;
import com.bxm.warcar.integration.distributed.DistributedLock;
import com.bxm.warcar.integration.distributed.DistributedLockBus;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
@AutoConfigureAfter(value={DistributedScheduledAutoConfiguration.class})
@ConditionalOnBean(value={DistributedLockBus.class})
public class DistributedScheduled {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedScheduled.class);
    private final DistributedLockBus distributedLockBus;

    public DistributedScheduled(DistributedLockBus distributedLockBus) {
        this.distributedLockBus = distributedLockBus;
    }

    @Pointcut(value="@annotation(org.springframework.scheduling.annotation.Scheduled)")
    public void pointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        boolean acquire = false;
        DistributedLock lock = null;
        try {
            Object target = point.getTarget();
            Method method = this.getMethod(point);
            if (null == method) {
                Object object = point.proceed();
                return object;
            }
            lock = this.distributedLockBus.getLock(target, method);
            if (null == lock) {
                Object object = point.proceed();
                return object;
            }
            acquire = lock.acquire();
            if (!acquire) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Distributed job {}#{} already execution at other machine.", target.getClass(), (Object)method.getName());
                }
                Object var6_8 = null;
                return var6_8;
            }
            Object proceed = point.proceed();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Distributed job {}#{} has been executed.", target.getClass(), (Object)method.getName());
            }
            Object object = proceed;
            return object;
        }
        finally {
            if (null != lock && acquire) {
                lock.release();
            }
        }
    }

    private Method getMethod(ProceedingJoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Class<?> targetClass = point.getTarget().getClass();
        try {
            return targetClass.getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("getMethod:", (Throwable)e);
            }
            return null;
        }
    }
}

