/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dspams.common.helper.autoconfigure;

import com.bxm.acl.facade.model.UserVo;
import com.bxm.dspams.common.helper.exception.DspamsException;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.springframework.web.context.request.RequestContextHolder;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class AutofillFieldInterceptor
implements Interceptor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Class<?> clazz;
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        if (SqlCommandType.DELETE.equals((Object)sqlCommandType)) {
            return invocation.proceed();
        }
        Object arg = invocation.getArgs()[1];
        Object parameter = null;
        if (arg instanceof MapperMethod.ParamMap) {
            MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)arg;
            String et = "et";
            if (!paramMap.containsKey((Object)et)) return invocation.proceed();
            parameter = paramMap.get((Object)et);
        } else {
            if (arg instanceof Map) {
                return invocation.proceed();
            }
            parameter = arg;
        }
        if (ClassUtils.isPrimitiveOrWrapper(clazz = parameter.getClass()) || String.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz)) {
            return invocation.proceed();
        }
        this.updateField(parameter, sqlCommandType);
        return invocation.proceed();
    }

    private void updateField(Object parameter, SqlCommandType sqlCommandType) throws IllegalAccessException {
        Class<?> cls = parameter.getClass();
        UserVo userVo = (UserVo)RequestContextHolder.getRequestAttributes().getAttribute("user", 0);
        if (SqlCommandType.INSERT.equals((Object)sqlCommandType)) {
            try {
                Field field = cls.getDeclaredField("createUser");
                this.setValue(parameter, field, userVo);
            }
            catch (NoSuchFieldException field) {}
        } else if (SqlCommandType.UPDATE.equals((Object)sqlCommandType)) {
            try {
                Field field = cls.getDeclaredField("modifyUser");
                this.setValue(parameter, field, userVo);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }

    private void setValue(Object parameter, Field field, UserVo userVo) throws IllegalAccessException {
        field.setAccessible(true);
        if (null == userVo) {
            if (null == field.get(parameter)) {
                throw new DspamsException("AutofillFieldInterceptor: userVo is null", new Object[0]);
            }
            return;
        }
        field.set(parameter, userVo.getUsername());
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }
}

