/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dspams.common.helper.util;

import com.bxm.acl.facade.model.UserVo;
import com.bxm.dspams.common.helper.enums.RoleEnum;
import com.bxm.warcar.utils.IpHelper;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class UserRoleUtil {
    private static final Logger log = LoggerFactory.getLogger(UserRoleUtil.class);

    public static UserVo getUser(HttpServletRequest request) {
        UserVo userVo = new UserVo();
        userVo.setUsername("admin");
        try {
            UserVo user = (UserVo)request.getAttribute("user");
            if (user == null) {
                return userVo;
            }
            user.setIp(IpHelper.getIpFromHeader((HttpServletRequest)request));
            return user;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return userVo;
        }
    }

    public static UserVo getUser() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return UserRoleUtil.getUser(requestAttributes.getRequest());
    }

    public static boolean isMj(UserVo user) {
        if (UserRoleUtil.checkUserRoleIsNull(user)) {
            return false;
        }
        return UserRoleUtil.isLeader(user) == false && user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_ZHUAN_YUAN.getCode());
    }

    public static boolean isBd(UserVo user) {
        if (UserRoleUtil.checkUserRoleIsNull(user)) {
            return false;
        }
        return UserRoleUtil.isLeader(user) == false && user.getRoleCodes().contains(RoleEnum.BD.getCode());
    }

    private static boolean checkUserRoleIsNull(UserVo user) {
        if (user == null) {
            return true;
        }
        return CollectionUtils.isEmpty((Collection)user.getRoleCodes());
    }

    public static boolean isAe(UserVo user) {
        if (UserRoleUtil.checkUserRoleIsNull(user)) {
            return false;
        }
        return UserRoleUtil.isLeader(user) == false && user.getRoleCodes().contains(RoleEnum.AE.getCode());
    }

    public static boolean isSale(UserVo user) {
        if (UserRoleUtil.checkUserRoleIsNull(user)) {
            return false;
        }
        return UserRoleUtil.isLeader(user) == false && user.getRoleCodes().contains(RoleEnum.SALE.getCode());
    }

    public static Boolean isLeader(UserVo user) {
        if (UserRoleUtil.checkUserRoleIsNull(user)) {
            return false;
        }
        return user.getRoleCodes().contains(RoleEnum.BDLEADER.getCode()) || user.getRoleCodes().contains(RoleEnum.SHANG_YE_HUA_YUN_YING_JING_LI.getCode()) || user.getRoleCodes().contains(RoleEnum.SALELEADER.getCode()) || user.getRoleCodes().contains(RoleEnum.AELEADER.getCode());
    }
}

