/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.datasync.autoconfigure.client;

import com.bxm.warcar.datasync.client.Action;
import com.bxm.warcar.datasync.client.Trigger;
import com.bxm.warcar.datasync.client.triggers.zk.ZkChildrenChangedListener;
import com.bxm.warcar.datasync.source.SourceController;
import com.bxm.warcar.zk.ZkClientHolder;
import com.bxm.warcar.zk.listener.ChildrenChangedListener;
import com.bxm.warcar.zk.listener.children.ChildrenChanged;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Action.class, SourceController.class})
@ConditionalOnProperty(value={"warcar.datasync.client"}, havingValue="true")
public class TriggerAutoConfiguration {
    @Bean
    public Trigger zkChildrenChangedListener(Action action, SourceController sourceController) {
        return new ZkChildrenChangedListener(action, sourceController);
    }

    @Bean(initMethod="init", destroyMethod="destroy")
    @ConditionalOnClass(value={ZkClientHolder.class, ZkChildrenChangedListener.class})
    public ChildrenChanged childrenChanged(ZkClientHolder zk, ZkChildrenChangedListener zkChildrenChangedListener) {
        return new ChildrenChanged(zk, "/warcar/data_sync", (ChildrenChangedListener)zkChildrenChangedListener);
    }
}

