/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.export.template;

import cn.afterturn.easypoi.util.PoiCellUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class TemplateSumHanlder {
    private Map<String, TemplateSumEntity> sumMap = new HashMap<String, TemplateSumEntity>();

    public TemplateSumHanlder(Sheet sheet) {
        this.getAllSumCell(sheet);
    }

    private void getAllSumCell(Sheet sheet) {
        Row row = null;
        int index = 0;
        while (index <= sheet.getLastRowNum()) {
            if ((row = sheet.getRow(index++)) == null) continue;
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                if (row.getCell(i) == null || !PoiCellUtil.getCellValue(row.getCell(i)).contains("sum:")) continue;
                this.addSumCellToList(row.getCell(i));
            }
        }
    }

    private void addSumCellToList(Cell cell) {
        String cellValue = cell.getStringCellValue();
        int index = 0;
        while ((index = TemplateSumHanlder.indexOfIgnoreCase(cellValue, "sum:", index)) != -1) {
            TemplateSumEntity entity = new TemplateSumEntity();
            entity.setCellValue(cellValue);
            entity.setSumKey(this.getSumKey(cellValue, index++));
            entity.setCol(cell.getColumnIndex());
            entity.setRow(cell.getRowIndex());
            this.sumMap.put(entity.getSumKey(), entity);
        }
    }

    public boolean isSumKey(String key) {
        return this.sumMap.containsKey(key);
    }

    private String getSumKey(String cellValue, int index) {
        return cellValue.substring(index + 5, cellValue.indexOf(")", index));
    }

    public void addValueOfKey(String key, String val) {
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{key})) {
            this.sumMap.get(key).setValue(this.sumMap.get(key).getValue() + Double.valueOf(val));
        }
    }

    public List<TemplateSumEntity> getDataList() {
        return new ArrayList<TemplateSumEntity>(this.sumMap.values());
    }

    public void addListSizeToSumEntity() {
    }

    public void shiftRows(int rowIndex, int size) {
        for (TemplateSumEntity entity : this.getDataList()) {
            if (entity.getRow() <= rowIndex) continue;
            entity.setRow(entity.getRow() + size);
        }
    }

    private static int indexOfIgnoreCase(String str, String searchStr, int startPos) {
        int endLimit;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        if (startPos > (endLimit = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return startPos;
        }
        for (int i = startPos; i < endLimit; ++i) {
            if (!str.regionMatches(true, i, searchStr, 0, searchStr.length())) continue;
            return i;
        }
        return -1;
    }

    protected class TemplateSumEntity {
        private String cellValue;
        private String sumKey;
        private int col;
        private int row;
        private double value;

        protected TemplateSumEntity() {
        }

        public String getCellValue() {
            return this.cellValue;
        }

        public void setCellValue(String cellValue) {
            this.cellValue = cellValue;
        }

        public String getSumKey() {
            return this.sumKey;
        }

        public void setSumKey(String sumKey) {
            this.sumKey = sumKey;
        }

        public int getCol() {
            return this.col;
        }

        public void setCol(int col) {
            this.col = col;
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }
    }
}

