#!/bin/bash

if [ ! -f ~/run/dspams-web.pid ]; then
  echo "Server [dspams-web] doest not started!"
  exit
fi

pid=`cat ~/run/dspams-web.pid`
if [ ! -n "${pid}" ]; then
  echo "illegal content in dspams-web.pid!"
  exit
fi

process=`ps -aux|awk '{print $2}' | grep ${pid}`
if [ -n "${process}" ]; then
  echo "Server [dspams-web] will be stop."
  kill ${pid}

  times=0
  while true
  do
    process=`ps -aux|awk '{print $2}' | grep ${pid}`
    if [ -n "${process}" ] && [ ${times} -lt 10 ]; then
      let times++
      sleep 1
    else
      break
    fi
  done

  process=`ps -aux|awk '{print $2}' | grep ${pid}`
  if [ -n "${process}" ]; then
    echo "Server [dspams-web] cannot stop, Please check pid file 'dspams-web.pid' and stop it by manually!"
    exit
  fi
else
  echo "Server [dspams-web] has been stoped!"
fi

rm -f ~/run/dspams-web.pid