package com.bxm.messager.controller.message;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.messager.common.model.dto.MessageTemplateDTO;
import com.bxm.messager.common.model.vo.MessageTemplateListInfoVO;
import com.bxm.messager.common.service.MessageTemplateService;
import com.bxm.messager.facade.dto.MessageInfoDTO;
import com.bxm.messager.facade.enums.ChannelEnum;
import com.bxm.messager.facade.enums.MessageOperateEnum;
import com.bxm.messager.facade.enums.MessagePushTopicTypeEnum;
import com.bxm.messager.facade.enums.PushStatusEnum;
import com.bxm.messager.facade.service.MessageInfoServiceFacade;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author pf.w
 * @date 2021/8/17 18:37
 **/
@RestController
@RequestMapping("/message/template")
public class MessageTemplateController {

    @Autowired
    private  MessageTemplateService messageTemplateService;

    @RequestMapping("getMessageTemplateList")
    public ResponseEntity<IPage<MessageTemplateListInfoVO>> getMessageTemplateList(MessageTemplateDTO param){
        return ResponseEntity.ok(messageTemplateService.getMessageTemplateList(param));
    }
}
