package com.bxm.messager.facade;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.messager.common.core.entity.MessageInfoEntity;
import com.bxm.messager.common.core.entity.MessageReadInfoEntity;
import com.bxm.messager.common.core.mapper.MessageInfoMapper;
import com.bxm.messager.common.core.service.MessageInfoService;
import com.bxm.messager.common.core.service.MessageReadInfoService;
import com.bxm.messager.common.model.bo.MessageInfoFacadeParamBO;
import com.bxm.messager.facade.bo.PageBO;
import com.bxm.messager.facade.dto.MessageInfoDTO;
import com.bxm.messager.facade.dto.MessageListInfoDTO;
import com.bxm.messager.facade.service.MessageInfoServiceFacade;
import com.bxm.messager.facade.vo.MessageInfoListVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author pf.w
 * @date 2021/8/18 14:47
 **/
@RestController
@Slf4j
public class MessageInfoServiceFacadeImpl implements MessageInfoServiceFacade {

    private  MessageInfoMapper messageInfoMapper;

    private MessageReadInfoService messageReadInfoService;

    private MessageInfoService messageInfoService;

    @Autowired
    public MessageInfoServiceFacadeImpl(MessageInfoMapper messageInfoMapper,
                                        MessageReadInfoService messageReadInfoService,
                                        MessageInfoService messageInfoService){
        this.messageInfoMapper = messageInfoMapper;
        this.messageReadInfoService = messageReadInfoService;
        this.messageInfoService = messageInfoService;
    }

    @Override
    public PageBO<MessageInfoListVO> messageList(Long channelId,
                                                                 Integer channel,
                                                                 Integer readFlag,
                                                                 Integer sender,
                                                                 String channelName,
                                                                 Integer pageNum,
                                                                 Integer pageSize) {
        if(log.isDebugEnabled()){
            log.debug("messageList channelId : {},channel : {},readFlag : {},sender : {},channelName : {},pageNum : {},pageSize : {}"
                    ,channelId,channel,readFlag,sender,channelName,pageSize,pageNum);
        }

        MessageListInfoDTO param =  MessageListInfoDTO.builder()
                .channelId(channelId)
                .channel(channel)
                .readFlag(readFlag)
                .sender(sender)
                .providerName(channelName)
                .build();
        param.setPageNum(pageNum);
        param.setPageSize(pageSize);

        //查询参数转化为可识别参数
        MessageInfoFacadeParamBO queryBean = this.covert(param);

        Page<MessageInfoListVO> page = new Page<>(param.getPageNum(),param.getPageSize());

        //获取分页数据
        IPage<MessageInfoListVO> iPageList = messageInfoMapper.getMessageListForFacade(page,queryBean);

        if(iPageList.getRecords().size()>0){
            //过滤数据（或者也叫填充下数据）
            this.fillContent(iPageList,param);
        }

        PageBO<MessageInfoListVO> resultPage = new PageBO<>();
        resultPage.setRecords(iPageList.getRecords());
        resultPage.setCurrent(iPageList.getCurrent());
        resultPage.setPages(iPageList.getPages());
        resultPage.setTotal(iPageList.getTotal());
        resultPage.setSize(iPageList.getSize());

        return resultPage;
    }

    /**
     * 填充数据
     * @param iPageList
     */
    private void fillContent(IPage<MessageInfoListVO> iPageList,MessageListInfoDTO param){

        List<MessageInfoListVO> resultList = iPageList.getRecords();

        if(CollectionUtils.isEmpty(resultList)){
            return;
        }

        //获取所有数据 包括未读和已读
       if(Objects.isNull(param.getReadFlag())){
           LambdaQueryWrapper<MessageReadInfoEntity> queryWrapper = new LambdaQueryWrapper<>();
           queryWrapper.eq(MessageReadInfoEntity::getGoalType,param.getChannel());
           queryWrapper.eq(MessageReadInfoEntity::getGoalUserId,param.getChannelId());
           queryWrapper.eq(MessageReadInfoEntity::getDeleted,0);
           List<MessageReadInfoEntity> readInfoEntities = messageReadInfoService.list(queryWrapper);

           //获取该渠道已读消息ids
           List<Long> hasReadMessageIds = readInfoEntities.stream().map(MessageReadInfoEntity::getMessageId).collect(Collectors.toList());

           resultList.forEach(infoListVO->{
               infoListVO.setReadFlag(hasReadMessageIds.contains(infoListVO.getId()) ? 1 : 0);
               infoListVO.setSender(infoListVO.getPushGoalType().equals(5) ? "系统通知" : "推送消息");
               fillMessageContent(infoListVO,param);
           });

           iPageList.setRecords(resultList);
       }else if(param.getReadFlag()==1){

           //设置已读
           resultList.forEach(infoListVO->{
               infoListVO.setReadFlag(1);
               infoListVO.setSender(infoListVO.getPushGoalType().equals(5) ? "系统通知" : "推送消息");
               fillMessageContent(infoListVO,param);
           });
           iPageList.setRecords(resultList);
       }else if(param.getReadFlag()==0){

           //设置未读
           resultList.forEach(infoListVO->{
               infoListVO.setReadFlag(0);
               infoListVO.setSender(infoListVO.getPushGoalType().equals(5) ? "系统通知" : "推送消息");
               fillMessageContent(infoListVO,param);
           });
           iPageList.setRecords(resultList);
       }else{
           return;
       }
    }

    private void fillMessageContent(MessageInfoListVO messageInfoListVO,MessageListInfoDTO param){
        if(Objects.isNull(messageInfoListVO.getPushContent())){
            return;
        }
        messageInfoListVO.setPushContent(messageInfoListVO.getPushContent().replace("${providerName}",param.getProviderName()));
    }

    private MessageInfoFacadeParamBO covert(MessageListInfoDTO param){
        return MessageInfoFacadeParamBO.builder()
                .channelId(Objects.isNull(param.getChannelId()) ? null : param.getChannelId().toString())
                .pushGoalType(Objects.isNull(param.getChannel()) ? null : param.getChannel())
                .sender(Objects.isNull(param.getSender()) ? null : param.getSender())
                .readFlag(Objects.isNull(param.getReadFlag()) ? null : param.getReadFlag())
                .build();
    }

    @Override
    public Boolean pushMessage(MessageInfoDTO param) {

        if(log.isDebugEnabled()){
            log.debug("param : {}",param);
        }

        MessageInfoEntity entity = new MessageInfoEntity();
        entity.setTitle(param.getTitle());
        entity.setType(1);
        entity.setPushTopicType(param.getPushTopicType());
        entity.setPushGoalType(param.getChannel());
        entity.setPushGoalDesc(param.getChannel().equals(1) ? "广告主" : "媒体");
        entity.setPushGoalUserContent(param.getPushGoalUserContent());
        entity.setPushContent(param.getPushContent());
        entity.setPushStatus(param.getPushStatus());
        entity.setPushDataTime(Objects.isNull(param.getPushDataTime()) ? new Date() : param.getPushDataTime());
        entity.setCreateUser(Objects.isNull(param.getCreateUser()) ? "未知" : param.getCreateUser());

        return messageInfoService.save(entity);
    }

    @Override
    public Boolean messageOperate(Long messageId, Integer operateType,Integer channel,Long subjectId) {
        if(log.isDebugEnabled()){
            log.debug("messageId : {},operateEnum : {}",operateType);
        }

        //校验非空
        if(Objects.isNull(messageId) || Objects.isNull(operateType) ||
                Objects.isNull(operateType) || Objects.isNull(subjectId)){
            return Boolean.FALSE;
        }

        MessageReadInfoEntity entity = new MessageReadInfoEntity();
        entity.setReadFlag(operateType);
        entity.setReadTime(new Date());
        entity.setGoalType(channel);
        entity.setMessageId(messageId);
        entity.setGoalUserId(subjectId);

        return messageReadInfoService.save(entity);
    }
}
