/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.facade.constant.redis;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

public final class AdxKeyGenerator {
    private static final String GLOBAL_CONFIG = "ADX:GLOBAL:CONFIG";

    public static KeyGenerator getConfig() {
        return () -> GLOBAL_CONFIG;
    }

    public static class Counter {
        public static KeyGenerator getSdk(String positionId, String ymd, String devNo) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX:COUNT:SDK:PID", positionId, "date", ymd, "dev", devNo});
        }

        public static KeyGenerator getTaskAcquireTime(Long taskId, String devNo) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX:COUNT:SDK:TASK:ACQ:TIMES", taskId, devNo});
        }
    }

    public static class Task {
        private static final String ALL = "ADX:SDK:TASK:ALL";
        private static final String OPENED = "ADX:SDK:TASK:OPENED";

        public static KeyGenerator getAllList() {
            return () -> ALL;
        }

        public static KeyGenerator getOpenedList() {
            return () -> OPENED;
        }

        public static KeyGenerator getRegionList(Long taskId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX:SDK:TASK", taskId, "REGION"});
        }

        public static KeyGenerator getAppRule(Long taskId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX:SDK:TASK", taskId, "APP"});
        }

        public static KeyGenerator getPositionRule(Long taskId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX:SDK:TASK", taskId, "POSITION"});
        }

        public static KeyGenerator getFrequencyRule(Long taskId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX:SDK:TASK", taskId, "FREQ"});
        }

        public static KeyGenerator getDeviceBrandRule(Long taskId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX:SDK:TASK", taskId, "DEVBRAND"});
        }

        public static KeyGenerator getTimeSlotRule(Long taskId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX:SDK:TASK", taskId, "TIMESLOT"});
        }

        public static KeyGenerator getCounter(Long taskId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX:SDK:TASK", taskId});
        }

        public static KeyGenerator getCounter(Long taskId, String ymd) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX:SDK:TASK", taskId, "date", ymd});
        }

        public static KeyGenerator getCounter(Long taskId, String ymd, String devNo) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX:SDK:TASK", taskId, "date", ymd, "dev", devNo});
        }

        public static KeyGenerator getCounterForDev(String ymd, String devNo) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX:SDK:TASK", "date", ymd, "dev", devNo});
        }
    }

    public static class Position {
        public static KeyGenerator getInfo(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX:POSITION:PID", positionId});
        }

        public static KeyGenerator getInfoByApp(String appPositionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX:POSITION:APPID", appPositionId});
        }

        public static KeyGenerator getPositionInteract() {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "POSITION", "INTERACT"});
        }
    }

    public static class App {
        public static KeyGenerator getInfo(String appId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX:APP:APPID", appId});
        }

        public static KeyGenerator getInfoByCustom(String customAppId, Integer platformType) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX:APP:CUSTOMAPPID", customAppId, "type", platformType});
        }
    }

    public static class Device {
        public static KeyGenerator getInitInfo(String devNo) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "SDK", "INIT", "devNo", devNo});
        }

        public static KeyGenerator getInitInstalledList(String devNo) {
            return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "SDK", "INIT", "devNo", devNo, "APPS"});
        }
    }
}

