/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.annotation;

import feign.MethodMetadata;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.web.bind.annotation.RequestHeader;

public class RequestHeaderParameterProcessor
implements AnnotatedParameterProcessor {
    private static final Class<RequestHeader> ANNOTATION = RequestHeader.class;

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return ANNOTATION;
    }

    @Override
    public boolean processArgument(AnnotatedParameterProcessor.AnnotatedParameterContext context, Annotation annotation, Method method) {
        int parameterIndex = context.getParameterIndex();
        Class<?> parameterType = method.getParameterTypes()[parameterIndex];
        MethodMetadata data = context.getMethodMetadata();
        if (Map.class.isAssignableFrom(parameterType)) {
            Util.checkState((data.headerMapIndex() == null ? 1 : 0) != 0, (String)"Header map can only be present once.", (Object[])new Object[0]);
            data.headerMapIndex(Integer.valueOf(parameterIndex));
            return true;
        }
        String name = ANNOTATION.cast(annotation).value();
        Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"RequestHeader.value() was empty on parameter %s", (Object[])new Object[]{parameterIndex});
        context.setParameterName(name);
        Collection<String> header = context.setTemplateParameter(name, (Collection)data.template().headers().get(name));
        data.template().header(name, header);
        return true;
    }
}

