#!/bin/bash

if [ ! -f ~/run/messager-web.pid ]; then
  echo "Server [messager-web] doest not started!"
  exit
fi

pid=`cat ~/run/messager-web.pid`
if [ ! -n "${pid}" ]; then
  echo "illegal content in messager-web.pid!"
  exit
fi

process=`ps -aux|awk '{print $2}' | grep ${pid}`
if [ -n "${process}" ]; then
  echo "Server [messager-web] will be stop."
  kill ${pid}

  times=0
  while true
  do
    process=`ps -aux|awk '{print $2}' | grep ${pid}`
    if [ -n "${process}" ] && [ ${times} -lt 10 ]; then
      let times++
      sleep 1
    else
      break
    fi
  done

  process=`ps -aux|awk '{print $2}' | grep ${pid}`
  if [ -n "${process}" ]; then
    echo "Server [messager-web] cannot stop, Please check pid file 'messager-web.pid' and stop it by manually!"
    exit
  fi
else
  echo "Server [messager-web] has been stoped!"
fi

rm -f ~/run/messager-web.pid