package com.bxm.messager.autoconfigure;

import com.bxm.acl.facade.AclAuthInterceptor;
import com.bxm.acl.facade.Utils;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.messager.common.integration.acl.AclUserIntegration;
import com.bxm.warcar.logging.OperatorExtractor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Objects;

/**
 * @author allen
 * @date 2020-06-12
 * @since 1.0
 */
@Slf4j
@Configuration
public class LoggingAutoConfiguration {

    @Bean
    public OperatorExtractor operatorExtractor(ObjectProvider<AclUserIntegration> provider) {
        AclUserIntegration service = provider.getIfAvailable();
        if (Objects.isNull(service)) {
            return null;
        }
        return request -> {
            String token = Utils.getToken(request);
            if (StringUtils.isBlank(token)) {
                return null;
            }
            Object attribute = request.getAttribute(AclAuthInterceptor.USER_KEY);
            if ((attribute instanceof UserVo)) {
                return ((UserVo) attribute).getUsername();
            }
            return null;
        };
    }
}
