/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.messager.controller.message;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.messager.common.helper.exception.BusinessException;
import com.bxm.messager.common.helper.exception.McCmsException;
import com.bxm.messager.common.model.dto.MessageDetailInfoDTO;
import com.bxm.messager.common.model.dto.MessageListExportDTO;
import com.bxm.messager.common.model.dto.MessageListInfoDTO;
import com.bxm.messager.common.model.vo.MessageDetailInfoVO;
import com.bxm.messager.common.model.vo.MessageListInfoVO;
import com.bxm.messager.common.model.vo.MessageTopicListInfoVO;
import com.bxm.messager.common.service.MessageService;
import com.bxm.warcar.file.autoconfigure.HttpFileConfiguration;
import com.bxm.warcar.file.upload.HttpFileManager;
import com.bxm.warcar.file.upload.HttpFileRequest;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/message"})
public class MessageController {
    private final MessageService messageService;
    private final HttpFileConfiguration httpFileConfiguration;
    private final HttpFileManager httpFileManager;

    @InitBinder
    public void initBinder(WebDataBinder binder, WebRequest request) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, true));
    }

    @RequestMapping(value={"getMessageInfoList"})
    public ResponseEntity<IPage<MessageListInfoVO>> getMessageList(MessageListInfoDTO param) {
        return ResponseEntity.ok((Object)this.messageService.getMessageList(param));
    }

    @PostMapping(value={"addMessage"})
    public ResponseEntity<Boolean> addMessage(@RequestBody MessageDetailInfoDTO param) {
        return ResponseEntity.ok((Object)this.messageService.addMessage(param));
    }

    @PostMapping(value={"editMessage"})
    public ResponseEntity<Boolean> editMessage(@RequestBody MessageDetailInfoDTO param) {
        return ResponseEntity.ok((Object)this.messageService.editMessage(param));
    }

    @RequestMapping(value={"getMessageDetail"})
    public ResponseEntity<MessageDetailInfoVO> getMessageInfo(Long messageId) {
        return ResponseEntity.ok((Object)this.messageService.getMessageInfo(messageId));
    }

    @PostMapping(value={"messageOperate"})
    public ResponseEntity<Boolean> messageOperate(Long messageId, Integer operateType) {
        return ResponseEntity.ok((Object)this.messageService.messageOperate(messageId, operateType));
    }

    @GetMapping(value={"messageListExport"})
    public void messageListExport(MessageListExportDTO param, HttpServletResponse response) {
        this.messageService.messageListExport(param, response);
    }

    @GetMapping(value={"getMessageTopicInfo"})
    public ResponseEntity<List<MessageTopicListInfoVO>> getMessageTopicInfo() {
        return ResponseEntity.ok((Object)this.messageService.getMessageTopicInfo());
    }

    @PostMapping(value={"/upload"})
    public ResponseEntity uploadImg(@RequestParam(value="file") MultipartFile file) throws Exception {
        if (file.isEmpty()) {
            throw new McCmsException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", new Object[0]);
        }
        if (file.getSize() > this.httpFileConfiguration.getLimitSize()) {
            throw new BusinessException("\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc7" + (double)this.httpFileConfiguration.getLimitSize() / 1048576.0 + "M\uff01");
        }
        return ResponseEntity.ok((Object)this.httpFileManager.upload(new HttpFileRequest(file)));
    }

    public MessageController(MessageService messageService, HttpFileConfiguration httpFileConfiguration, HttpFileManager httpFileManager) {
        this.messageService = messageService;
        this.httpFileConfiguration = httpFileConfiguration;
        this.httpFileManager = httpFileManager;
    }
}

