/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.messager.facade;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.messager.common.constant.MessageConstant;
import com.bxm.messager.common.core.entity.MessageInfoEntity;
import com.bxm.messager.common.core.entity.MessageReadInfoEntity;
import com.bxm.messager.common.core.mapper.MessageInfoMapper;
import com.bxm.messager.common.core.service.MessageInfoService;
import com.bxm.messager.common.core.service.MessageReadInfoService;
import com.bxm.messager.common.model.bo.MessageInfoFacadeParamBO;
import com.bxm.messager.facade.bo.PageBO;
import com.bxm.messager.facade.dto.MessageInfoDTO;
import com.bxm.messager.facade.dto.MessageListInfoDTO;
import com.bxm.messager.facade.enums.ChannelEnum;
import com.bxm.messager.facade.service.MessageInfoServiceFacade;
import com.bxm.messager.facade.vo.MessageInfoListVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MessageInfoServiceFacadeImpl
implements MessageInfoServiceFacade {
    private static final Logger log = LoggerFactory.getLogger(MessageInfoServiceFacadeImpl.class);
    private MessageInfoMapper messageInfoMapper;
    private MessageReadInfoService messageReadInfoService;
    private MessageInfoService messageInfoService;
    private MessageConstant messageConstant;

    @Autowired
    public MessageInfoServiceFacadeImpl(MessageInfoMapper messageInfoMapper, MessageReadInfoService messageReadInfoService, MessageInfoService messageInfoService, MessageConstant messageConstant) {
        this.messageInfoMapper = messageInfoMapper;
        this.messageReadInfoService = messageReadInfoService;
        this.messageInfoService = messageInfoService;
        this.messageConstant = messageConstant;
    }

    public PageBO<MessageInfoListVO> messageList(Long channelId, Integer channel, Integer readFlag, Integer sender, String channelName, Integer pageNum, Integer pageSize) {
        if (log.isDebugEnabled()) {
            log.debug("messageList channelId : {},channel : {},readFlag : {},sender : {},channelName : {},pageNum : {},pageSize : {}", new Object[]{channelId, channel, readFlag, sender, channelName, pageSize, pageNum});
        }
        MessageListInfoDTO param = MessageListInfoDTO.builder().channelId(channelId).channel(channel).readFlag(readFlag).sender(sender).providerName(channelName).build();
        param.setPageNum(pageNum);
        param.setPageSize(pageSize);
        MessageInfoFacadeParamBO queryBean = this.covert(param);
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        IPage iPageList = this.messageInfoMapper.getMessageListForFacade(page, queryBean);
        if (iPageList.getRecords().size() > 0) {
            this.fillContent((IPage<MessageInfoListVO>)iPageList, param);
        }
        PageBO resultPage = new PageBO();
        resultPage.setRecords(iPageList.getRecords());
        resultPage.setCurrent(iPageList.getCurrent());
        resultPage.setPages(iPageList.getPages());
        resultPage.setTotal(iPageList.getTotal());
        resultPage.setSize(iPageList.getSize());
        return resultPage;
    }

    public Integer getUnReadNum(Long channelId, Integer channel) {
        return this.messageInfoMapper.getUnReadNum(channelId, channel);
    }

    private void fillContent(IPage<MessageInfoListVO> iPageList, MessageListInfoDTO param) {
        List resultList = iPageList.getRecords();
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return;
        }
        if (Objects.isNull(param.getReadFlag())) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(MessageReadInfoEntity::getGoalType, (Object)param.getChannel());
            queryWrapper.eq(MessageReadInfoEntity::getGoalUserId, (Object)param.getChannelId());
            queryWrapper.eq(MessageReadInfoEntity::getDeleted, (Object)0);
            List readInfoEntities = this.messageReadInfoService.list((Wrapper)queryWrapper);
            List hasReadMessageIds = readInfoEntities.stream().map(MessageReadInfoEntity::getMessageId).collect(Collectors.toList());
            resultList.forEach(infoListVO -> {
                infoListVO.setReadFlag(Integer.valueOf(hasReadMessageIds.contains(infoListVO.getId()) ? 1 : 0));
                infoListVO.setSender(infoListVO.getPushTopicType().equals(5) ? "\u7cfb\u7edf\u901a\u77e5" : "\u63a8\u9001\u6d88\u606f");
                this.fillMessageContent((MessageInfoListVO)infoListVO, param);
            });
            iPageList.setRecords(resultList);
        } else if (param.getReadFlag() == 1) {
            resultList.forEach(infoListVO -> {
                infoListVO.setReadFlag(Integer.valueOf(1));
                infoListVO.setSender(infoListVO.getPushTopicType().equals(5) ? "\u7cfb\u7edf\u901a\u77e5" : "\u63a8\u9001\u6d88\u606f");
                this.fillMessageContent((MessageInfoListVO)infoListVO, param);
            });
            iPageList.setRecords(resultList);
        } else if (param.getReadFlag() == 0) {
            resultList.forEach(infoListVO -> {
                infoListVO.setReadFlag(Integer.valueOf(0));
                infoListVO.setSender(infoListVO.getPushTopicType().equals(5) ? "\u7cfb\u7edf\u901a\u77e5" : "\u63a8\u9001\u6d88\u606f");
                this.fillMessageContent((MessageInfoListVO)infoListVO, param);
            });
            iPageList.setRecords(resultList);
        } else {
            return;
        }
    }

    private void fillMessageContent(MessageInfoListVO messageInfoListVO, MessageListInfoDTO param) {
        if (Objects.isNull(messageInfoListVO.getPushContent())) {
            return;
        }
        messageInfoListVO.setPushContent(messageInfoListVO.getPushContent().replace(this.messageConstant.messageContentCard, param.getProviderName()));
    }

    private MessageInfoFacadeParamBO covert(MessageListInfoDTO param) {
        return MessageInfoFacadeParamBO.builder().channelId(Objects.isNull(param.getChannelId()) ? null : param.getChannelId().toString()).pushGoalType(Objects.isNull(param.getChannel()) ? null : param.getChannel()).sender(Objects.isNull(param.getSender()) ? null : param.getSender()).readFlag(Objects.isNull(param.getReadFlag()) ? null : param.getReadFlag()).build();
    }

    public Boolean pushMessage(@RequestBody MessageInfoDTO param) {
        if (log.isDebugEnabled()) {
            log.debug("param : {}", (Object)param);
        }
        MessageInfoEntity entity = new MessageInfoEntity();
        entity.setTitle(param.getTitle());
        entity.setType(Integer.valueOf(1));
        entity.setPushTopicType(param.getPushTopicType());
        entity.setPushGoalType(param.getChannel());
        entity.setPushGoalUserType(param.getPushGoalUserType());
        entity.setPushGoalDesc(Objects.isNull(ChannelEnum.getChannelEnum((int)param.getChannel())) ? "\u5176\u4ed6" : ChannelEnum.getChannelEnum((int)param.getChannel()).getDesc());
        entity.setPushGoalUserContent(param.getPushGoalUserContent());
        entity.setPushContent(param.getPushContent());
        entity.setPushStatus(param.getPushStatus());
        entity.setPushDataTime(Objects.isNull(param.getPushDataTime()) ? new Date() : param.getPushDataTime());
        entity.setCreateUser(Objects.isNull(param.getCreateUser()) ? "\u672a\u77e5" : param.getCreateUser());
        return this.messageInfoService.save((Object)entity);
    }

    public Boolean messageOperate(Long messageId, Integer operateType, Integer channel, Long subjectId) {
        if (log.isDebugEnabled()) {
            log.debug("messageId : {},operateType : {},channel : {},channelId", new Object[]{messageId, operateType, channel, subjectId});
        }
        if (Objects.isNull(messageId) || Objects.isNull(operateType) || Objects.isNull(operateType) || Objects.isNull(subjectId)) {
            return Boolean.FALSE;
        }
        MessageReadInfoEntity entityBo = (MessageReadInfoEntity)this.messageReadInfoService.getById((Serializable)messageId);
        if (!Objects.isNull(entityBo)) {
            return Boolean.TRUE;
        }
        MessageReadInfoEntity entity = new MessageReadInfoEntity();
        entity.setReadFlag(operateType);
        entity.setReadTime(new Date());
        entity.setGoalType(channel);
        entity.setMessageId(messageId);
        entity.setGoalUserId(subjectId);
        return this.messageReadInfoService.save((Object)entity);
    }
}

