/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.logging;

import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class Logging {
    private String applicationId;
    private String requestedSessionId;
    private String scheme;
    private String host;
    private int port;
    private String method;
    private String path;
    private String queryString;
    private Map<String, String[]> params;
    private String clientIp;
    private String serverIp;
    private Map<String, String> headers;
    private Date startTime = new Date();
    private Date endTime;
    private String requestBody;
    private String responseBody;
    private long consumeTimeInMillis;
    private boolean success;
    private String throwable;
    private String operator;

    private Logging() {
    }

    static Logging build(String applicationId, HttpServletRequest request, long startTimeInMillis, String requestBody, String responseBody, boolean success, String throwable, String operator) {
        Logging o = new Logging();
        o.applicationId = applicationId;
        o.requestedSessionId = request.getRequestedSessionId();
        o.scheme = request.getScheme();
        o.host = request.getServerName();
        o.port = request.getServerPort();
        o.method = request.getMethod();
        o.path = request.getRequestURI();
        o.queryString = request.getQueryString();
        o.params = request.getParameterMap();
        o.clientIp = Logging.getIpFromHeader(request);
        o.serverIp = request.getLocalAddr();
        o.headers = Logging.getHeaderMap(request);
        o.startTime = new Date(startTimeInMillis);
        o.endTime = new Date();
        o.requestBody = requestBody;
        o.responseBody = responseBody;
        o.consumeTimeInMillis = o.endTime.getTime() - o.startTime.getTime();
        o.success = success;
        o.throwable = throwable;
        o.operator = operator;
        return o;
    }

    private static Map<String, String> getHeaderMap(HttpServletRequest req) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration enu = req.getHeaderNames();
        while (enu.hasMoreElements()) {
            String headerName = (String)enu.nextElement();
            String headerValue = req.getHeader(headerName);
            map.put(headerName, headerValue);
        }
        return map;
    }

    private static String getIpFromHeader(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String ip = request.getHeader("X-Forwarded-For");
        if (StringUtils.isNotBlank((String)ip) && !"unknown".equalsIgnoreCase(ip)) {
            return ip;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Map<String, String[]> getParams() {
        return this.params;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public long getConsumeTimeInMillis() {
        return this.consumeTimeInMillis;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getThrowable() {
        return this.throwable;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String toString() {
        return "Logging{requestedSessionId='" + this.requestedSessionId + '\'' + ", applicationId='" + this.applicationId + '\'' + ", scheme='" + this.scheme + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", method='" + this.method + '\'' + ", path='" + this.path + '\'' + ", queryString='" + this.queryString + '\'' + ", params=" + this.params + ", clientIp='" + this.clientIp + '\'' + ", serverIp='" + this.serverIp + '\'' + ", headers=" + this.headers + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", requestBody='" + this.requestBody + '\'' + ", responseBody='" + this.responseBody + '\'' + ", consumeTimeInMillis=" + this.consumeTimeInMillis + ", success=" + this.success + ", throwable='" + this.throwable + '\'' + ", operator='" + this.operator + '\'' + '}';
    }
}

