/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.conversion;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mapstruct.ap.internal.conversion.SimpleConversion;
import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.model.common.Type;

public abstract class AbstractNumberToStringConversion
extends SimpleConversion {
    private final boolean sourceTypeNumberSubclass;

    public AbstractNumberToStringConversion(boolean sourceTypeNumberSubclass) {
        this.sourceTypeNumberSubclass = sourceTypeNumberSubclass;
    }

    @Override
    public Set<Type> getToConversionImportTypes(ConversionContext conversionContext) {
        if (this.requiresDecimalFormat(conversionContext)) {
            return Collections.singleton(conversionContext.getTypeFactory().getType(DecimalFormat.class));
        }
        return super.getToConversionImportTypes(conversionContext);
    }

    protected boolean requiresDecimalFormat(ConversionContext conversionContext) {
        return this.sourceTypeNumberSubclass && conversionContext.getNumberFormat() != null;
    }

    @Override
    protected Set<Type> getFromConversionImportTypes(ConversionContext conversionContext) {
        if (this.requiresDecimalFormat(conversionContext)) {
            return Collections.singleton(conversionContext.getTypeFactory().getType(DecimalFormat.class));
        }
        return super.getFromConversionImportTypes(conversionContext);
    }

    @Override
    protected List<Type> getFromConversionExceptionTypes(ConversionContext conversionContext) {
        if (this.requiresDecimalFormat(conversionContext)) {
            return Collections.singletonList(conversionContext.getTypeFactory().getType(ParseException.class));
        }
        return super.getFromConversionExceptionTypes(conversionContext);
    }
}

