/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.messager.autoconfigure;

import com.bxm.acl.facade.Utils;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.messager.common.integration.acl.AclUserIntegration;
import com.bxm.warcar.logging.OperatorExtractor;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LoggingAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LoggingAutoConfiguration.class);

    @Bean
    public OperatorExtractor operatorExtractor(ObjectProvider<AclUserIntegration> provider) {
        AclUserIntegration service = (AclUserIntegration)provider.getIfAvailable();
        if (Objects.isNull(service)) {
            return null;
        }
        return request -> {
            String token = Utils.getToken((HttpServletRequest)request);
            if (StringUtils.isBlank((CharSequence)token)) {
                return null;
            }
            Object attribute = request.getAttribute("user");
            if (attribute instanceof UserVo) {
                return ((UserVo)attribute).getUsername();
            }
            return null;
        };
    }
}

