package com.bxm.datapark.facade.ocpc;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;

/**
 * OCPC 广告券统计
 * @author allen
 * @since 1.1.5
 */
public class OcpcStatistics implements Serializable {

    private static final long serialVersionUID = -2548698957740796664L;

    private String appName;
    private String position;
    private String positionname;
    private Integer ticketid;
    private String ticketname;
    private String adshop;
    private String shopsname;
    private String ae;
    private Integer views;
    private Integer clicks;
    @Field("click_ratio")
    private Double clickRatio;
    @Field("valid_clicks")
    private Integer vaildClicks;
    @Field("total_consume")
    private Long totalConsume;
    @Field("avg_cpa")
    private Double avgCpa;

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getPositionname() {
        return positionname;
    }

    public void setPositionname(String positionname) {
        this.positionname = positionname;
    }

    public Integer getTicketid() {
        return ticketid;
    }

    public void setTicketid(Integer ticketid) {
        this.ticketid = ticketid;
    }

    public String getTicketname() {
        return ticketname;
    }

    public void setTicketname(String ticketname) {
        this.ticketname = ticketname;
    }

    public String getAdshop() {
        return adshop;
    }

    public void setAdshop(String adshop) {
        this.adshop = adshop;
    }

    public String getShopsname() {
        return shopsname;
    }

    public void setShopsname(String shopsname) {
        this.shopsname = shopsname;
    }

    public String getAe() {
        return ae;
    }

    public void setAe(String ae) {
        this.ae = ae;
    }

    public Integer getViews() {
        return views;
    }

    public void setViews(Integer views) {
        this.views = views;
    }

    public Integer getClicks() {
        return clicks;
    }

    public void setClicks(Integer clicks) {
        this.clicks = clicks;
    }

    public Double getClickRatio() {
        return clickRatio;
    }

    public void setClickRatio(Double clickRatio) {
        this.clickRatio = clickRatio;
    }

    public Integer getVaildClicks() {
        return vaildClicks;
    }

    public void setVaildClicks(Integer vaildClicks) {
        this.vaildClicks = vaildClicks;
    }

    public Long getTotalConsume() {
        return totalConsume;
    }

    public void setTotalConsume(Long totalConsume) {
        this.totalConsume = totalConsume;
    }

    public Double getAvgCpa() {
        return avgCpa;
    }

    public void setAvgCpa(Double avgCpa) {
        this.avgCpa = avgCpa;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
