package com.bxm.datapark.facade.income;

import com.bxm.datapark.model.media.AppCount;
import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <h3>媒体收益相关</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/04/10 20:35
 */
@FeignClient(name = "datapark")
@RequestMapping("/meidaIncome")
public interface MeidaIncomeService {


	@RequestMapping(value = "/updateMeidaIncome", method = RequestMethod.POST)
	public void updateMeidaIncome(@RequestParam(value = "datetime", required = true) String datetime,
								  @RequestParam(value = "mapAppIncome", required = true) String mapAppIncome,
								  @RequestParam(value = "mapApp", required = true) String mapApp,
								  @RequestParam(value = "mapBusinessIncome", required = true) String mapBusinessIncome,
								  @RequestParam(value = "mapBusiness", required = true) String mapBusiness,
								  @RequestParam(value = "appkeyList", required = true)  String appkeyList);





	/**
	 * 对外暴露接口
	 * 导出报表
	 * @param datetime
	 * @param json
	 * @param sortName
	 * @param sortType
	 * @return
	 */
	@RequestMapping(value = "/app/export",method = RequestMethod.GET)
	public ResultModel<List<AppCount>> getAppCountExport(
			@RequestParam(name = "datetime") String datetime,
			@RequestParam(name = "json", required = false) String json,
			@RequestParam(name = "sortName", defaultValue = "openPv") String sortName,
			@RequestParam(name = "sortType", defaultValue = "desc") String sortType);



	/**
	 *子链接的点击量
	 * @param datetime
	 * @return
	 */
	@RequestMapping(value = "/app/business/profit",method = RequestMethod.GET)
	public ResultModel<List<AppCount>>findAppBusinessCountProfit(@RequestParam(name = "datetime") String datetime);

}
