package com.bxm.datapark.facade.income;


import com.bxm.datapark.model.media.TicketCountCommon;
import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <h3>广告券收益相关</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/04/10 20:35
 */
@FeignClient(name = "datapark")
@RequestMapping("/ticketIncome")
public interface TicketIncomeService {

	@RequestMapping(value = "/test1", method = RequestMethod.GET)
	public void test();


	@RequestMapping(value = "/updateTicketIncome", method = RequestMethod.POST)
	public void updateTicketIncome(@RequestParam(value = "mapCertificate", required = true) String mapCertificate,
								   @RequestParam(value = "mapApp", required = true) String mapApp,
								   @RequestParam(value = "mapBusiness", required = true) String mapBusiness,
								   @RequestParam(value = "datetime", required = true) String datetime,
								   @RequestParam(value = "certificateidList", required = true) String certificateidList);



	@RequestMapping(value = "/ticket/profit",method = RequestMethod.GET)
	public ResultModel<List<TicketCountCommon>> findTicketProfit(
			@RequestParam(name = "datetime") String datetime,
			@RequestParam(name = "type", required = false) String type,
			@RequestParam(name = "certificateid", required = false) Long certificateid);


	/**
	 * 广告卷维度查询
	 * @param datetime
	 * @param certificateid
	 * @param appkey
	 * @param scene
	 * @param type
	 * @param json
	 * @return
	 */
	@RequestMapping("/ticket/export")
	public ResultModel<List<TicketCountCommon>> findTicketCount(
			@RequestParam(name ="datetime") String datetime,
			@RequestParam(name = "certificateid", required = false) Long certificateid,
			@RequestParam(name = "appkey", required = false) String appkey,
			@RequestParam(name = "scene", required = false) Integer scene,
			@RequestParam(name = "type", required = false) String type,
			@RequestParam(name = "json", required = false) String json);


	/**
	 * 权重查询
	 * @param json
	 * @param datetime
	 * @param appkey
	 * @return
	 */
	@RequestMapping("/ticket/weight")
	public ResultModel<List<TicketCountCommon>> findTicketCommon(
			@RequestParam(name = "json", required = false) String json,
			@RequestParam(name = "datetime") String datetime,
			@RequestParam(name = "appkey", required = false) String appkey);
}
