package com.bxm.datapark.facade.adpopup.service;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.adpopup.model.dto.PopupPositionDto;
import com.bxm.datapark.facade.adpopup.model.vo.*;
import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 弹窗分析报表服务
 *
 * @author zhounan
 * created on 2018/8/6
 */
@FeignClient(name = "datapark")
public interface PopupAnalyseReportService {

    @RequestMapping(value = "/analyse/trend")
    ResultModel listTrend(@RequestParam("scene") String scene, @RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime, @RequestParam("orderType") String orderType, @RequestParam("orderParam") String orderParam);

    @RequestMapping("/analyse/trend/top3")
    ResultModel<List<List<AdPopupVo>>> listTop3(@RequestParam("scene") String scene, @RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime, @RequestParam("sortName") String sortName);

    @RequestMapping("/analyse/trend/listTbl")
    ResultModel<Page<AdPopupVo>> listTbl(@RequestParam("scene") String scene, @RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime, @RequestParam("popupId") String popupId, @RequestParam("page") Integer page, @RequestParam("pageSize") Integer pageSize, @RequestParam("sortName") String sortName, @RequestParam("sortType") String sortType);

    @RequestMapping("/analyse/trend/listTblAll")
    ResultModel<List<AdPopupVo>> listTblAll(@RequestParam("scene") String scene, @RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime, @RequestParam("popupId") String popupId, @RequestParam("sortName") String sortName, @RequestParam("sortType") String sortType);

    @RequestMapping("/analyse/listActivityType")
    ResultModel<List<PopupActivityVo>> listActivityType(@RequestParam("date") String date, @RequestParam("popupid") String popupid, @RequestParam("activityType") String activityType, @RequestParam("sortName") String sortName, @RequestParam("sortType") String sortType);

    @RequestMapping("/analyse/listActivityTypeByPage")
    ResultModel<Page<PopupActivityVo>> listActivityTypeByPage(@RequestParam("date") String date, @RequestParam("popupid") String popupid, @RequestParam("activityType") String activityType, @RequestParam("sortName") String sortName, @RequestParam("sortType") String sortType, @RequestParam("page") Integer page, @RequestParam("pageSize") Integer pageSize);

    @RequestMapping("/analyse/listPositionByPage")
    ResultModel<Page<PopupPositionVo>> listPositionByPage(@RequestParam("date") String date, @RequestParam("popupId") String popupId, @RequestParam("appKey") String appKey, @RequestParam("positionId") String positionId, @RequestParam("sortName") String sortName, @RequestParam("sortType") String sortType, @RequestParam("page") Integer page, @RequestParam("pageSize") Integer pageSize);
    
    @RequestMapping(value = "/analyse/listPositionByPageNew",method = RequestMethod.POST)
    ResultModel<Page<PopupPositionVo>> listPositionByPageNew(@RequestBody PopupPositionDto param);
        
    @RequestMapping("/analyse/listPosition")
    ResultModel<List<PopupPositionVo>> listPosition(@RequestParam("date") String date, @RequestParam("popupId") String popupId, @RequestParam("appKey") String appKey, @RequestParam("positionId") String positionId, @RequestParam("sortName") String sortName, @RequestParam("sortType") String sortType);
    
    @RequestMapping(value = "/analyse/listPositionNew",method = RequestMethod.POST)
    ResultModel<List<PopupPositionVo>> listPositionNew(@RequestBody PopupPositionDto param);
        
    @RequestMapping("/analyse/stay/join")
    ResultModel listStayTrendJoin(@RequestParam("scene") String scene, @RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime);

    @RequestMapping("/analyse/stay/click")
    ResultModel listStayTrendClick(@RequestParam("scene") String scene, @RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime);

    @RequestMapping("/analyse/stay/listStayPosition")
    ResultModel<List<StayPopupPositionVo>> listStayPosition(@RequestParam("date") String date, @RequestParam("popupId") String popupId, @RequestParam("appKey") String appKey, @RequestParam("positionId") String positionId, @RequestParam("scene") String scene, @RequestParam("sortName") String sortName, @RequestParam("sortType") String sortType);
   
    @RequestMapping(value = "/analyse/stay/listStayPositionNew",method = RequestMethod.POST)
    ResultModel<List<StayPopupPositionVo>> listStayPositionNew(@RequestBody PopupPositionDto param);
        
    @RequestMapping("/analyse/stay/listStayPositionByPage")
    ResultModel<Page<StayPopupPositionVo>> listStayPositionByPage(@RequestParam("date") String date, @RequestParam("popupId") String popupId, @RequestParam("appKey") String appKey, @RequestParam("positionId") String positionId, @RequestParam("scene") String scene, @RequestParam("page") Integer page, @RequestParam("pageSize") Integer pageSize, @RequestParam("sortName") String sortName, @RequestParam("sortType") String sortType);
    
    @RequestMapping(value = "/analyse/stay/listStayPositionByPageNew",method = RequestMethod.POST)
    public ResultModel<Page<StayPopupPositionVo>> listStayPositionByPageNew(@RequestBody PopupPositionDto param);
        
    @RequestMapping("/analyse/stay/position/export")
    ResultModel<List<StayPopupPositionVo>> listStayPositionExport(@RequestParam("date") String date, @RequestParam("popupId") String popupId, @RequestParam("appKey") String appKey, @RequestParam("positionId") String positionId, @RequestParam("scene") String scene, @RequestParam("sortName") String sortName, @RequestParam("sortType") String sortType);

    @RequestMapping("/analyse/stay/listStayTblByPage")
    ResultModel<Page<StayPopupTrendVo>> listStayTblByPage(@RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime, @RequestParam("scene") String scene, @RequestParam("popupId") String popupId, @RequestParam("sortName") String sortName, @RequestParam("sortType") String sortType, @RequestParam("pageAble") Integer pageAble, @RequestParam("page") Integer page, @RequestParam("pageSize") Integer pageSize);

    @RequestMapping("/analyse/stay/tblAll")
    ResultModel<List<StayPopupTrendVo>> listStayTblAll(@RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime, @RequestParam("scene") String scene, @RequestParam("popupId") String popupId, @RequestParam("sortName") String sortName, @RequestParam("sortType") String sortType);
}
