package com.bxm.datapark.facade.floatmaterial;

import com.bxm.datapark.facade.floatmaterial.model.dto.FloatMaterialCountDto;
import com.bxm.datapark.facade.floatmaterial.model.vo.FloatMaterialCountVo;
import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * 浮标素材统计
 */
@FeignClient(name="datapark")
public interface FloatMaterialCountService {

    @RequestMapping(value = "/floatmaterial/count", method = { RequestMethod.POST}, consumes="application/json")
    ResultModel<List<FloatMaterialCountVo>> floatmaterialCount(@RequestBody FloatMaterialCountDto dto);

    @RequestMapping(value = "/floatmaterial/datereport", method = { RequestMethod.POST}, consumes="application/json")
    ResultModel<List<FloatMaterialCountVo>> datereport(@RequestBody FloatMaterialCountDto dto);

}
