package com.bxm.datapark.facade.app.model.vo;

/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with http://www.bianxianmao.com.
 */

import com.bxm.util.dto.VoUtil;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 * 广告券日报
 * @author bcc
 */
public class TicketCountCommonVo implements Serializable{


    private static final long serialVersionUID = -6710758344330604280L;

    /**
     * 编号
     */
    private String number;

    /**
     * 日期
     */

    private String datetime;


    /**
     * 券id
     */

    private Long certificateid;

    /**
     * appkey
     */

    private String appkey;

    /**
     * 子渠道标志
     */

    private String business;

    /**
     * 发券请求
     */

    private Integer sendPv;
    /**
     * 发券请求涨幅
     */

    private String sendPvChange;
    /**
     * 点击量
     */

    private Integer clickPv;
    /**
     * 点击量涨幅
     */

    private String clickPvChange;

    /**
     * 曝光量（发券量）
     */

    private Integer openPv;

    /**
     * 曝光量（发券量）涨幅
     */
    private String openPvChange;

    /**
     * 有效点击量
     */
    private Integer validClick;

    /**
     * 有效点击量涨幅
     */
    private String validClickChange;


    /**
     * 有效点击率
     */
    private Double validClickRate;


    /**
     * 有效点击率涨幅
     */
    private String validClickRateChange;

    /**
     * 转化率
     */
    private Double conversion;

    /**
     * 转化率涨幅
     */
    private String conversionChange;

    /**
     * 券收入
     */
    private Double income;

    /**
     * 券收入涨幅
     */
    private String incomeChange;


    /**
     * 发券aurp
     */
    private Double openPvAurp;
    /**
     * 发券aurp涨幅
     */
    private String openPvAurpChange;
    /**
     * 点击aurp
     */
    private Double clickAurp;
    /**
     * 点击aurp涨幅
     */
    private String clickAurpChange;

    /**
     * 有效点击率占比
     */
    private Double qualityFactor;

    /**
     * 有效点击率占比涨幅
     */
    private String qualityFactorChange;


    private Integer hours;

    /**
     * 是否是首张弹券
     */

    private Integer scene;

    /**
     * 发券占比
     */
    private Double openPvRate;

    /**
     * 发券占比涨幅
     */
    private String openPvRateChange;

    /**
     * 券消耗
     */

    private  Double consume;

    /**
     * 券消耗涨幅
     */
    private  String consumeChange;

    /**
     * 曝光成功率
     */
    private  Double exposureRate;

    /**
     * 曝光成功率涨幅
     */
    private  String exposureRateChange;

    /**
     * 成功曝光数
     */
    private Integer exposurePv;

    /**
     * 礼券日平均权重
     * add by kk,xie times:2018-7-8 11:50:03
     */
    private BigDecimal averageWeightByDay;

    /**
     * 礼券发券机会
     * add by kk,xie times:2018-7-8 11:50:03
     */
    private String sendTicketProbability;

    /**
     * 礼券发券的设备限制
     * add by kk,xie times:2018-7-8 11:50:03
     */
    private String equipmentConstraints;

    /**
     * 礼券发券的环境限制
     * add by kk,xie times:2018-7-8 11:50:03
     */
    private String environmentConstraints;

    /**
     * 礼券发券的地域限制
     * add by kk,xie times:2018-7-8 11:50:03
     */
    private String regionConstraints;

    /**
     * 礼券的总发券机会
     * add by kk,xie times:2018-7-8 11:50:03
     */
    private String totalSendTicketProbability;

    /**
     * 发券时间
     * add by kk,xie times:2018-7-4 11:50:03
     */
    private String sendTicketTime;

    public String getSendTicketTime() {
        return sendTicketTime;
    }

    public void setSendTicketTime(String sendTicketTime) {
        this.sendTicketTime = sendTicketTime;
    }

    public BigDecimal getAverageWeightByDay() {
        return averageWeightByDay;
    }

    public void setAverageWeightByDay(BigDecimal averageWeightByDay) {
        this.averageWeightByDay = averageWeightByDay;
    }

    public String getSendTicketProbability() {
        return sendTicketProbability;
    }

    public void setSendTicketProbability(String sendTicketProbability) {
        this.sendTicketProbability = sendTicketProbability;
    }

    public String getEquipmentConstraints() {
        return equipmentConstraints;
    }

    public void setEquipmentConstraints(String equipmentConstraints) {
        this.equipmentConstraints = equipmentConstraints;
    }

    public String getEnvironmentConstraints() {
        return environmentConstraints;
    }

    public void setEnvironmentConstraints(String environmentConstraints) {
        this.environmentConstraints = environmentConstraints;
    }

    public String getRegionConstraints() {
        return regionConstraints;
    }

    public void setRegionConstraints(String regionConstraints) {
        this.regionConstraints = regionConstraints;
    }

    public String getTotalSendTicketProbability() {
        return totalSendTicketProbability;
    }

    public void setTotalSendTicketProbability(String totalSendTicketProbability) {
        this.totalSendTicketProbability = totalSendTicketProbability;
    }

    public Double getConsume() {
        return   consume!=null? consume:0;
    }

    public void setConsume(Double consume) {
        this.consume = consume;
    }

    public String getConsumeChange() {
        return VoUtil.percentage(consumeChange);
    }

    public void setConsumeChange(String consumeChange) {
        this.consumeChange = consumeChange;
    }

    public Double getExposureRate() {
        return exposureRate;
    }

    public void setExposureRate(Double exposureRate) {
        this.exposureRate = exposureRate;
    }

    public String getExposureRateChange() {
        return  VoUtil.percentage(exposureRateChange);
    }

    public void setExposureRateChange(String exposureRateChange) {
        this.exposureRateChange = exposureRateChange;
    }


    public Integer getExposurePv() {
        return exposurePv;
    }

    public void setExposurePv(Integer exposurePv) {
        this.exposurePv = exposurePv;
    }

    public Integer getHours() {
        return hours;
    }

    public void setHours(Integer hours) {
        this.hours = hours;
    }

    public Double getIncome() {
        return income==null?0D:income;
    }

    public void setIncome(Double income) {
        this.income = income;
    }

    public String getDatetime() {
        return datetime;
    }

    public Long getCertificateid() {
        return certificateid;
    }

    public String getAppkey() {
        return appkey;
    }

    public String getBusiness() {
        return business;
    }

    public Integer getSendPv() {
        return sendPv;
    }

    public String getSendPvChange() {
        return VoUtil.percentage(sendPvChange);
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public String getClickPvChange() {
        return VoUtil.percentage(clickPvChange);
    }

    public Integer getOpenPv() {
        return openPv;
    }

    public String getOpenPvChange() {
        return VoUtil.percentage(openPvChange);
    }

    public Integer getValidClick() {
        return validClick;
    }

    public String getValidClickChange() {
        return VoUtil.percentage(validClickChange);
    }

    public Double getValidClickRate() {
        return validClickRate;
    }

    public String getValidClickRateChange() {
        return VoUtil.percentage(validClickRateChange);
    }

    public Double getConversion() {
        return conversion;
    }

    public String getConversionChange() {
        return VoUtil.percentage(conversionChange);
    }

    public String getIncomeChange() {
        return VoUtil.percentage(incomeChange);
    }

    public Double getOpenPvAurp() {
        return openPvAurp;
    }

    public String getOpenPvAurpChange() {
        return VoUtil.percentage(openPvAurpChange);
    }

    public Double getClickAurp() {
        return clickAurp;
    }

    public String getClickAurpChange() {
        return VoUtil.percentage(clickAurpChange);
    }

    public Double getQualityFactor() {
        return qualityFactor;
    }

    public String getQualityFactorChange() {
        return VoUtil.percentage(qualityFactorChange);
    }

    public Double getOpenPvRate() {
        return openPvRate;
    }

    public String getOpenPvRateChange() {
        return VoUtil.percentage(openPvRateChange);
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public void setCertificateid(Long certificateid) {
        this.certificateid = certificateid;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public void setSendPv(Integer sendPv) {
        this.sendPv = sendPv;
    }

    public void setSendPvChange(String sendPvChange) {
        this.sendPvChange = sendPvChange;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public void setClickPvChange(String clickPvChange) {
        this.clickPvChange = clickPvChange;
    }

    public void setOpenPv(Integer openPv) {
        this.openPv = openPv;
    }

    public void setOpenPvChange(String openPvChange) {
        this.openPvChange = openPvChange;
    }

    public void setValidClick(Integer validClick) {
        this.validClick = validClick;
    }

    public void setValidClickChange(String validClickChange) {
        this.validClickChange = validClickChange;
    }

    public void setValidClickRate(Double validClickRate) {
        this.validClickRate = validClickRate;
    }

    public void setValidClickRateChange(String validClickRateChange) {
        this.validClickRateChange = validClickRateChange;
    }

    public void setConversion(Double conversion) {
        this.conversion = conversion;
    }

    public void setConversionChange(String conversionChange) {
        this.conversionChange = conversionChange;
    }

    public void setIncomeChange(String incomeChange) {
        this.incomeChange = incomeChange;
    }

    public void setOpenPvAurp(Double openPvAurp) {
        this.openPvAurp = openPvAurp;
    }

    public void setOpenPvAurpChange(String openPvAurpChange) {
        this.openPvAurpChange = openPvAurpChange;
    }

    public void setClickAurp(Double clickAurp) {
        this.clickAurp = clickAurp;
    }

    public void setClickAurpChange(String clickAurpChange) {
        this.clickAurpChange = clickAurpChange;
    }

    public void setQualityFactor(Double qualityFactor) {
        this.qualityFactor = qualityFactor;
    }

    public void setQualityFactorChange(String qualityFactorChange) {
        this.qualityFactorChange = qualityFactorChange;
    }

    public void setOpenPvRate(Double openPvRate) {
        this.openPvRate = openPvRate;
    }

    public void setOpenPvRateChange(String openPvRateChange) {
        this.openPvRateChange = openPvRateChange;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    public TicketCountCommonVo() {
    }

    @Override
    public String toString() {
        return "TicketCountCommon{" +
                "consume=" + consume +
                ", exposureRate=" + exposureRate +
                ", exposurePv=" + exposurePv +
                '}';
    }
}
