package com.bxm.datapark.facade.ticket.service;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ticket.model.dto.AppBusinessTicketDto;
import com.bxm.datapark.facade.ticket.model.vo.TicketCountCommonVo;
import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;


/**
 * 类说明：广告券日报相关报表服务
 * @author 作者： bcc
 * @version 创建时间：2018年7月23日 下午4:21:43
 */
@FeignClient(name="datapark")
public interface TicketDataReportSevice {

    /**
     * 广告券日报
     * @param dto
     * @return
     */
    @RequestMapping(value = "/ticket", method = RequestMethod.POST, consumes="application/json")
    ResultModel<Page<TicketCountCommonVo>> ticketReport(@RequestBody AppBusinessTicketDto dto);

    /**
     * 广告券日报导出
     * @param dto
     * @return
     */
    @RequestMapping(value = "/ticket/export", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<TicketCountCommonVo>> ticketReportExport(@RequestBody AppBusinessTicketDto dto);

    /**
     * 广告券日报-按日
     * @param dto
     * @return
     */
    @RequestMapping(value = "/ticket/date", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<TicketCountCommonVo>> ticketDateReport(@RequestBody AppBusinessTicketDto dto);


    /**
     * 广告券日报-按小时
     * @param dto
     * @return
     */
    @RequestMapping(value = "/ticket/hour", method = RequestMethod.POST, consumes="application/json")
    ResultModel<Page<TicketCountCommonVo>> ticketHourReport(@RequestBody AppBusinessTicketDto dto);


    /**
     * 广告券日报-按小时 导出
     * @param dto
     * @return
     */
    @RequestMapping(value = "/ticket/hour/export", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<TicketCountCommonVo>> ticketHourReportExport(@RequestBody AppBusinessTicketDto dto);



}
