package com.bxm.datapark.facade.alarm.service;

import com.bxm.datapark.facade.alarm.model.AlarmCountDto;
import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


/**
 * Created by wuwenquan on 2018/12/10.
 */
//报警指标统计
@FeignClient(name="datapark")
public interface AlarmCountService {
    //获取指定时段非去重的报警指标指标和
    @RequestMapping(value = "/alarm/findNoRepeatCount", method = RequestMethod.POST, consumes="application/json")
    ResultModel<Long> findNoRepeatCount (@RequestBody AlarmCountDto alarmCountDto);

    //获得去重UV指标和
    @RequestMapping(value = "/alarm/findUvByDay", method = RequestMethod.POST, consumes="application/json")
    ResultModel<Long> findUvByDay(@RequestBody  AlarmCountDto alarmCountDto);

}
