package com.bxm.datapark.facade.position.model.dto;

import java.io.Serializable;
import java.util.List;

import com.bxm.datapark.facade.app.model.dto.AppCommonDto;

/**
* @Title:PositionUserPortrait.java
* @Package:com.bxm.datapark.model.mongo.vo.position
* @Description: 广告位用户画像实体类
* @date:2018年8月8日 下午6:39:22
 */
public class PositionUserPortraitDto extends AppCommonDto implements Serializable{

    private static final long serialVersionUID = -1985711628497205766L;
    
    private String collectionName = "ad_app_business_user_portrait_d_stat";
    /**
     * 开始时间
     */
    private String startTime;
    
    /**
     * 结束时间
     */
    private String endTime;
    
    /**
     * 广告位ID、广告位名称
     */
    private String keywords;
    /**
     * 广告位ID
     */
    private String positionId;
    
    /**
     * 广告位ID的集合
     */
    private List<String> positionIds;
    
    
    /**
     * 降序或者升序
     */
    private String sortType;
    
    /**
     * 排序字段
     */
    private String sortParam;
    
    /**
     * appKey精确或者appName模糊
     */
    private String appKeywords;
    
    /**
     * 媒体名称
     */
    private String appName;
    
    /**
     * 广告位名称
     */
    private String appEntranceName;
    
    /**
     * 年龄样本数
     */
    private Double ageSampleSize;
    
    /**
     * <18占比
     */
    private Double proportionUnder18;
    
    /**
     * 18-22占比
     */
    private Double proportion18between22;
    
    /**
     * 23-50占比
     */
    private Double proportion23between50;
    
    /**
     * 50以上占比
     */
    private Double proportionOver50;
    
    /**
     * 职业样本数
     */
    private Double occupationSampleSize;
    
    /**
     * 学生占比
     */
    private Double studentProportion;
    
    /**
     * 上班占比
     */
    private Double workProportion;
    
    /**
     * 待业占比
     */
    private Double proportionUnemployedu;
    
    /**
     * 页面号
     */
    private Integer pageNum = 1;
    
    /**
     * 页面大小
     */
    private Integer pageSize = 20;
    
    public List<String> getPositionIds() {
        return positionIds;
    }

    public void setPositionIds(List<String> positionIds) {
        this.positionIds = positionIds;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppEntranceName() {
        return appEntranceName;
    }

    public void setAppEntranceName(String appEntranceName) {
        this.appEntranceName = appEntranceName;
    }

    public Double getAgeSampleSize() {
        return ageSampleSize;
    }

    public void setAgeSampleSize(Double ageSampleSize) {
        this.ageSampleSize = ageSampleSize;
    }

    public Double getProportionUnder18() {
        return proportionUnder18;
    }

    public void setProportionUnder18(Double proportionUnder18) {
        this.proportionUnder18 = proportionUnder18;
    }

    public Double getProportion18between22() {
        return proportion18between22;
    }

    public void setProportion18between22(Double proportion18between22) {
        this.proportion18between22 = proportion18between22;
    }

    public Double getProportion23between50() {
        return proportion23between50;
    }

    public void setProportion23between50(Double proportion23between50) {
        this.proportion23between50 = proportion23between50;
    }

    public Double getProportionOver50() {
        return proportionOver50;
    }

    public void setProportionOver50(Double proportionOver50) {
        this.proportionOver50 = proportionOver50;
    }

    public Double getOccupationSampleSize() {
        return occupationSampleSize;
    }

    public void setOccupationSampleSize(Double occupationSampleSize) {
        this.occupationSampleSize = occupationSampleSize;
    }

    public Double getStudentProportion() {
        return studentProportion;
    }

    public void setStudentProportion(Double studentProportion) {
        this.studentProportion = studentProportion;
    }

    public Double getWorkProportion() {
        return workProportion;
    }

    public void setWorkProportion(Double workProportion) {
        this.workProportion = workProportion;
    }

    public Double getProportionUnemployedu() {
        return proportionUnemployedu;
    }

    public void setProportionUnemployedu(Double proportionUnemployedu) {
        this.proportionUnemployedu = proportionUnemployedu;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getCollectionName() {
        return collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getSortType() {
        return sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSortParam() {
        return sortParam;
    }

    public void setSortParam(String sortParam) {
        this.sortParam = sortParam;
    }

    public String getAppKeywords() {
        return appKeywords;
    }

    public void setAppKeywords(String appKeywords) {
        this.appKeywords = appKeywords;
    }
    
}
