package com.bxm.datapark.facade.ticket.service;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ticket.model.dto.AppBusinessTicketDto;
import com.bxm.datapark.facade.ticket.model.dto.SendTicketDetailDto;
import com.bxm.datapark.facade.ticket.model.dto.SendTicketDto;
import com.bxm.datapark.facade.ticket.model.dto.TicketUrlDto;
import com.bxm.datapark.facade.ticket.model.vo.SendTicketDetailVo;
import com.bxm.datapark.facade.ticket.model.vo.SendTicketVo;
import com.bxm.datapark.facade.ticket.model.vo.TicketCountCommonVo;
import com.bxm.datapark.facade.ticket.model.vo.TicketUrlVo;
import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 类说明：广告券日报相关报表服务
 * @author 作者： bcc
 * @version 创建时间：2018年7月23日 下午4:21:43
 */
@FeignClient(name="datapark")
public interface TicketDataReportSevice {

    /**
     * 广告券日报
     * @param dto
     * @return
     */
    @RequestMapping(value = "/ticket", method = RequestMethod.POST, consumes="application/json")
    ResultModel<Page<TicketCountCommonVo>> ticketReport(@RequestBody AppBusinessTicketDto dto);

    /**
     * 广告券日报导出
     * @param dto
     * @return
     */
    @RequestMapping(value = "/ticket/export", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<TicketCountCommonVo>> ticketReportExport(@RequestBody AppBusinessTicketDto dto);

    /**
     * 广告券日报-按日
     * @param dto
     * @return
     */
    @RequestMapping(value = "/ticket/date", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<TicketCountCommonVo>> ticketDateReport(@RequestBody AppBusinessTicketDto dto);


    /**
     * 广告券日报-按小时
     * @param dto
     * @return
     */
    @RequestMapping(value = "/ticket/hour", method = RequestMethod.POST, consumes="application/json")
    ResultModel<Page<TicketCountCommonVo>> ticketHourReport(@RequestBody AppBusinessTicketDto dto);


    /**
     * 广告券日报-按小时 导出
     * @param dto
     * @return
     */
    @RequestMapping(value = "/ticket/hour/export", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<TicketCountCommonVo>> ticketHourReportExport(@RequestBody AppBusinessTicketDto dto);
    
    /**
     * 
    * @Title: analysisTicketUrl  
    * @Description: 广告落地页统计
    * @return ResultModel<Page<TicketUrlVo>> 
     */
    @RequestMapping(value = "/ticketurl/list", method = RequestMethod.POST, consumes="application/json")
    ResultModel<Page<TicketUrlVo>> analysisTicketUrl(@RequestBody TicketUrlDto param);

    /**
     *
     * @Title: sendTicketCompare
     * @Description: 发券对比
     * @return ResultModel<Page<SendTicketVo>>
     */
    @RequestMapping(value = "/report/sendticket/compare", method = RequestMethod.POST, consumes="application/json")
    ResultModel<Page<SendTicketVo>> getTicketCompare(@RequestBody SendTicketDto sendTicketDto);

    /**
     *
     * @Title: sendTicketCompare
     * @Description: 发券arpu对比详细
     * @return ResultModel<Page<SendTicketVo>>
     */
    @RequestMapping(value = "/report/sendticket/compareDetail", method = RequestMethod.POST, consumes="application/json")
    ResultModel<Page<SendTicketDetailVo>> getTicketCompareDetail(@RequestBody SendTicketDetailDto sendTicketDetailDto);

    /**
     *
     * @Title: 统计表表定时任务
     * @Description:
     * @return
     */
    @GetMapping("/spare/certificate")
    public void spareCertificate(@RequestParam(name = "datetime") String datetime);

    /**
     *
     * @Title: 统计表表定时任务(按小时维度)
     * @Description:
     * @return
     */
    @GetMapping("/spare/certificate/hour")
    public void spareCertificateForHour(@RequestParam(name = "datetime") String datetime,@RequestParam(name = "hour",required = false) Integer hour);

    /**
     *
     * 功能描述: 广告券日报按日合计
     * @fileName:
     * @param:
     * @return:
     * @auther: sunzs
     * @date: 2019/3/4 17:10
     */
    @RequestMapping(value = "/ticket/findTicketCountSum")
    public ResultModel<List<TicketCountCommonVo>> findTicketCountSum(@RequestParam(name = "startTime") String startTime,
                                                                     @RequestParam(name = "endTime") String endTime,
                                                                     @RequestParam(name = "json") String json,
                                                                     @RequestParam(name = "sortType") String sortType,
                                                                     @RequestParam(name = "sortName")String sortName);

    /**
     * 查询广告券日报(广告主后台)
     */
    @PostMapping("/advertiser/ticket/date")
    ResultModel<List<TicketCountCommonVo>> selectTicketCount(@RequestBody AppBusinessTicketDto dto);


    /**
     * 查询广告券-子链接(广告主后台)
     */
    @PostMapping("/advertiser/ticket/app/business")
    ResultModel<List<TicketCountCommonVo>> selectTicketCountByTicketId(@RequestBody AppBusinessTicketDto dto);


    }
