package com.bxm.datapark.facade.venue.service;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.venue.model.dto.VenueReportDto;
import com.bxm.datapark.facade.venue.model.vo.VenueReportVo;
import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


/**
 * 主会场报表facade包
 * @author bcc
 */
@FeignClient(name="datapark")
public interface VenueReportService {

    @RequestMapping(value = "/venue/report", method = { RequestMethod.POST})
    ResultModel<Page<VenueReportVo>> venueReport(@RequestBody VenueReportDto dto);

    @RequestMapping(value = "/venue/date/report", method = { RequestMethod.POST})
    ResultModel<Page<VenueReportVo>> venueDateReport(@RequestBody VenueReportDto dto);

}
