package com.bxm.datapark.facade.order.model.dto;

import java.io.Serializable;
import java.util.List;

import com.bxm.datapark.facade.app.model.dto.AppCommonDto;
/**
* @Title:BusinessOrder.java
* @Package:com.bxm.datapark.model.mongo.vo.newad
* @Description: 货到付款订单
 */
public class BusinessOrderDto extends AppCommonDto implements Serializable {

    private static final long serialVersionUID = -4457121968900236164L;
    
    private String collectionName = "ad_app_business_cod_d_stat";
    /**
     * 开始时间
     */
    private String startTime;
    
    /**
     * 结束时间
     */
    private String endTime;
    
    /**
     * 广告券查询条件,券ID、券名称
     */
    private String adQuery;
    
    /**
     * 广告位ID、广告位名称
     */
    private String keywords;
    /**
     *广告ID
     */
    private Long certificateId;
    
    /**
     * 广告名称
     */
    private String shopsname;
    
    /**
     * 媒体名称
     */
    private String appName;
    
    /**
     * appKey精确或者appName模糊
     */
    private String appKeywords;
    
    /**
     * 广告位名称
     */
    private String appEntranceName;
    
    /**
     * 广告位ID
     */
    private String positionId;
    
    /**
     * 广告位ID的集合
     */
    private List<String> positionIdList;
    
    /**
     * 订单数
     */
    private Double orderQuantity;
    
    /**
     * 待发货数
     */
    private Double pendingDelivery;
    
    /**
     * 在途数
     */
    private Double inTransit;
    
    /**
     * 签收
     */
    private Double signin;
    
    /**
     * 退回数
     */
    private Double returnNum;
    
    /**
     * 取消发货数
     */
    private Double cancelDelivery;
    
    /**
     * 签收率
     */
    private Double signinRate;
    
    /**
     * 退回率
     */
    private Double returnRate;
    
    /**
     * 取消率
     */
    private Double cancelRate;
    
    /**
     * 页面号
     */
    private Integer pageNum = 1;
    
    /**
     * 页面大小
     */
    private Integer pageSize = 20;
    
    /**
     * 降序或者升序
     */
    private String sortType;
    
    /**
     * 排序字段
     */
    private String sortParam;
    

    public Long getCertificateId() {
        return certificateId;
    }

    public void setCertificateId(Long certificateId) {
        this.certificateId = certificateId;
    }

    public String getShopsname() {
        return shopsname;
    }

    public void setShopsname(String shopsname) {
        this.shopsname = shopsname;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppEntranceName() {
        return appEntranceName;
    }

    public void setAppEntranceName(String appEntranceName) {
        this.appEntranceName = appEntranceName;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public Double getOrderQuantity() {
        return orderQuantity;
    }

    public void setOrderQuantity(Double orderQuantity) {
        this.orderQuantity = orderQuantity;
    }

    public Double getPendingDelivery() {
        return pendingDelivery;
    }

    public void setPendingDelivery(Double pendingDelivery) {
        this.pendingDelivery = pendingDelivery;
    }

    public Double getInTransit() {
        return inTransit;
    }

    public void setInTransit(Double inTransit) {
        this.inTransit = inTransit;
    }

    public Double getSignin() {
        return signin;
    }

    public void setSignin(Double signin) {
        this.signin = signin;
    }

    public Double getReturnNum() {
        return returnNum;
    }

    public void setReturnNum(Double returnNum) {
        this.returnNum = returnNum;
    }

    public Double getCancelDelivery() {
        return cancelDelivery;
    }

    public void setCancelDelivery(Double cancelDelivery) {
        this.cancelDelivery = cancelDelivery;
    }

    public Double getSigninRate() {
        return signinRate;
    }

    public void setSigninRate(Double signinRate) {
        this.signinRate = signinRate;
    }

    public Double getReturnRate() {
        return returnRate;
    }

    public void setReturnRate(Double returnRate) {
        this.returnRate = returnRate;
    }

    public Double getCancelRate() {
        return cancelRate;
    }

    public void setCancelRate(Double cancelRate) {
        this.cancelRate = cancelRate;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getCollectionName() {
        return collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getSortType() {
        return sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSortParam() {
        return sortParam;
    }

    public void setSortParam(String sortParam) {
        this.sortParam = sortParam;
    }

    public String getAdQuery() {
        return adQuery;
    }

    public void setAdQuery(String adQuery) {
        this.adQuery = adQuery;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public List<String> getPositionIdList() {
        return positionIdList;
    }

    public void setPositionIdList(List<String> positionIdList) {
        this.positionIdList = positionIdList;
    }

    public String getAppKeywords() {
        return appKeywords;
    }

    public void setAppKeywords(String appKeywords) {
        this.appKeywords = appKeywords;
    }
    
}
