package com.bxm.datapark.facade.positiontest;

import com.bxm.datapark.facade.Page;
import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <h3>权限拦截</h3>
 * <p></p>
 * @author hcmony
 * @since V1.0.0, 2019/04/10 15:13
 */
@FeignClient(name="datapark")
public interface PositionTestFacadeService {

    /**
     * 媒体测试
     * 
     * @param keywords 广告id或者名称
     * @param positionid 入口id
     * @param pageSize 每页数量
     * @param pageNum 页码
     * @param sortName 排序名称
     * @param sortType 正序还是倒序
     * @param searchtype 1按照广告券 2按照广告券类型 3按照省市 4操作系统 5 微信/支付宝
     * @param areatype 当按照省市的时候 1是省 2 是市
     * @param shopType 广告券类型
     * @param
     * @return
     */
    @RequestMapping(value = "/positiontest/getPositionTestReport",method = RequestMethod.POST,consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResultModel<Page<PositionTestByTicket>> getPositionTestReport(@RequestParam(name = MongoConstant.KEYWORDS, required = false) String keywords,
                                                                         @RequestParam(name = MongoConstant.SHOP_TYPE, required = false) String shoptype,
                                                                         @RequestParam(name = MongoConstant.AREA_TYPE, required = false) String areatype,
                                                                         @RequestParam(name = MongoConstant.SEARCH_TYPE, required = true) String searchtype,
                                                                         @RequestParam(name = MongoConstant.POSITIONID, required = true) String positionid,
                                                                         @RequestParam(name = MongoConstant.PAGE_SIZE, defaultValue = MongoConstant.TEN_S) Integer pageSize,
                                                                         @RequestParam(name = MongoConstant.PAGE_NUM, defaultValue = MongoConstant.ONE_S) Integer pageNum,
                                                                         @RequestParam(name = MongoConstant.SORT_NAME, defaultValue = "openPvAurp") String sortName,
                                                                         @RequestParam(name = MongoConstant.SORT_TYPE, defaultValue = MongoConstant.SORT_TYPE_DESC) String sortType) ;


    /**
     * //媒体测试按广告券导出
     * 
     * @param keywords 广告id或者名称
     * @param positionid 入口id
     * @param pageSize 每页数量
     * @param sortType 正序还是倒序
     * @return
     */
    @RequestMapping(value = "/positiontest/getPositionTest/export" ,method = RequestMethod.POST, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResultModel<List<PositionTestByTicket>> getPositionTestExport(@RequestParam(name = MongoConstant.KEYWORDS, required = false) String keywords,
                                                                         @RequestParam(name = MongoConstant.SHOP_TYPE, required = false) String shoptype,
                                                                         @RequestParam(name = MongoConstant.AREA_TYPE, required = false) String areatype,
                                                                         @RequestParam(name = MongoConstant.SEARCH_TYPE, required = true) String searchtype,
                                                                         @RequestParam(name = MongoConstant.POSITIONID, required = true) String positionid,
                                                                         @RequestParam(name = MongoConstant.SORT_NAME, defaultValue = "openPvAurp") String sortName,
                                                                         @RequestParam(name = MongoConstant.SORT_TYPE, defaultValue = MongoConstant.SORT_TYPE_DESC) String sortType) ;


    /**
     * 媒体测试删除所有
     * @return
     */
    @RequestMapping(value = "/positiontest/removeAll",method = RequestMethod.GET)
    public ResultModel<Boolean> removeAll() ;

}
