package com.bxm.datapark.facade.ticket.model.vo.analysis;

import java.io.Serializable;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/8/9 11:29
 * 修 改 人：
 * 日 期：
 * 描 述： 广告券分析结果 基类
 * 版 本 号： v1
 */
public class BaseAnalysisVO implements Serializable {
    private static final long serialVersionUID = 2234921491060109532L;

    /**
     * 媒体ID, 广告位ID, 广告ID
     */
    private String appKey;
    private String positionId;
    private String ticketId;

    /**
     * 发券数, 点击数
     */
    private Integer openPV;
    private Integer clickPV;

    /**
     * 效果监测数, 广告总收入
     */
    private Integer pageExposurePV;
    private Double income;

    /**
     * 点击ARPU, 发券ARPU,  效果成本, 创建时间, 点击率, CVR
     */
    private Double clickArpu;
    private Double openArpu;
    private Double costEffect;
    private String createTime;
    private Double clickRate;
    private Double cvr;

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getTicketId() {
        return ticketId;
    }

    public void setTicketId(String ticketId) {
        this.ticketId = ticketId;
    }

    public Integer getOpenPV() {
        return openPV;
    }

    public void setOpenPV(Integer openPV) {
        this.openPV = openPV;
    }

    public Integer getClickPV() {
        return clickPV;
    }

    public void setClickPV(Integer clickPV) {
        this.clickPV = clickPV;
    }

    public Integer getPageExposurePV() {
        return pageExposurePV;
    }

    public void setPageExposurePV(Integer pageExposurePV) {
        this.pageExposurePV = pageExposurePV;
    }

    public Double getIncome() {
        return income;
    }

    public void setIncome(Double income) {
        this.income = income;
    }

    public Double getClickArpu() {
        return clickArpu;
    }

    public void setClickArpu(Double clickArpu) {
        this.clickArpu = clickArpu;
    }

    public Double getOpenArpu() {
        return openArpu;
    }

    public void setOpenArpu(Double openArpu) {
        this.openArpu = openArpu;
    }

    public Double getCostEffect() {
        return costEffect;
    }

    public void setCostEffect(Double costEffect) {
        this.costEffect = costEffect;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public Double getClickRate() {
        return clickRate;
    }

    public void setClickRate(Double clickRate) {
        this.clickRate = clickRate;
    }

    public Double getCvr() {
        return cvr;
    }

    public void setCvr(Double cvr) {
        this.cvr = cvr;
    }

    public BaseAnalysisVO() {
        this.openPV = 0;
        this.clickPV = 0;
        this.pageExposurePV = 0;
        this.income = 0.0;
        this.clickArpu = 0.0;
        this.openArpu = 0.0;
        this.costEffect = 0.0;
        this.clickRate = 0.0;
        this.cvr = 0.0;
    }
}
