package com.bxm.datapark.facade.weight;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 礼券-广告位-按小时权重浮动信息查询api
 *
 * @ClassName TicketWeightFeigh
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/8 18:57
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/8 18:57
 **/
@FeignClient(name="datapark")
public interface TicketWeightFeignCilent {
    /**
     * 礼券在广告位上按小时权重集查询接口
     *
     * @param datetime
   * @param appKey
   * @param business
   * @param ticketId
   * @param pageNum
   * @param pageSize
     * @return com.bxm.datapark.facade.weight.TicketWeightHourVo
     * @throws
     * @author kk.xie
     * @date 2018/7/8 19:01
     */
    @RequestMapping(value = "/app/business/ticketWeightHour", method = RequestMethod.GET)
    TicketWeightHourVo getTicketHourWeight(@RequestParam("datetime") String datetime, @RequestParam("appKey") String appKey,
                                           @RequestParam("business") String business, @RequestParam("ticketId") String ticketId,
                                           @RequestParam(required = false, defaultValue = "1", name = "pageNum") int pageNum,
                                           @RequestParam(required = false, defaultValue = "10", name = "pageSize") int pageSize);
}
