package com.bxm.datapark.web;

import java.util.List;

import com.bxm.datapark.web.model.AdAssetsData;
import com.bxm.datapark.web.model.AdAssetsDataDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bxm.datapark.DataParkConstants;
import com.bxm.datapark.web.model.AssetsAnalysisData;
import com.bxm.datapark.web.model.AssetsAnalysisDataDTO;
import com.bxm.util.dto.ResultModel;

/**
 * 广告素材相关的数据<br/>
 *
 * @author kerry.jiang
 * @date 2020/8/24 15:19
 */
@FeignClient(name = DataParkConstants.WEB_SERVICE)
public interface FacadeAdAssetsDataService {

    /**
     * 有效点击<br/>
     *
     * @param search
     * @return com.bxm.util.dto.ResultModel<java.util.List<com.bxm.datapark.web.model.AssetsAnalysisData>>
     */
    @RequestMapping(value = "/assets/list", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<AssetsAnalysisData>> getAssetsAnalysisList(@RequestBody AssetsAnalysisDataDTO search);


    /**
     * 根据ticketId 查出所有素材 统计
     * @param search
     * @return
     */
    @RequestMapping(value = "/assets/getDataByTicket", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<AdAssetsData>> getDataByTicket(@RequestBody AdAssetsDataDTO search);

}