package com.bxm.datapark.web;

import com.bxm.datapark.DataParkConstants;
import com.bxm.datapark.facade.positiontest.MongoConstant;
import com.bxm.datapark.facade.ticket.model.dto.AppBusinessTicketDto;
import com.bxm.datapark.facade.ticket.model.vo.TicketCountCommonVo;
import com.bxm.datapark.web.model.SearchDataCommon;
import com.bxm.datapark.web.model.TicketData;
import com.bxm.datapark.web.model.old.vo.newad.TicketPvUv;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * <h3>广告券相关的数据</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2019/11/11 14:00
 */
@FeignClient(name = DataParkConstants.WEB_SERVICE)
public interface FacadeAdTicketDataService {

    @RequestMapping("/data/ticket/position")
    public ResultModel<List<TicketData>> getTicketPositionData(@RequestBody SearchDataCommon search);

    @RequestMapping("/data/ticket")
    public ResultModel<List<TicketData>> getAdTicketData(@RequestBody SearchDataCommon search);

    @RequestMapping("/ticket/findTicketPvUvByList")
    public com.bxm.util.dto.ResultModel<List<TicketPvUv>> findTicketCountByList(@RequestBody SearchDataCommon search);


    /**
     * 迁移：运营后台广告券列表-查询券的有效点击
     * @param dto
     * @return
     */
    @RequestMapping(value = "/ticket/export", method = RequestMethod.POST, consumes="application/json")
    com.bxm.util.dto.ResultModel<List<TicketCountCommonVo>> ticketReportExport(@RequestBody AppBusinessTicketDto dto);


}