package com.bxm.datapark.web;

import com.bxm.datapark.DataParkConstants;
import com.bxm.datapark.facade.adsmedia.model.vo.AppCount;
import com.bxm.datapark.web.model.SearchDataCommon;
import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Set;

@FeignClient(name = DataParkConstants.WEB_SERVICE)
public interface FacadeAdsmediaDataService {

    /**
     * 根据appKey获取开发者所有广告位（子渠道）的数据,返回结果按子渠道维度
     *
     * @param startTime
     * @param endTime
     * @param appKey
     * @return
     */
    @RequestMapping("/data/adsmedia/getAppAllBusinessCount")
    ResultModel<List<AppCount>> getAppAllBusinessCount(@RequestParam("startTime") String startTime,
                                                       @RequestParam("endTime") String endTime, @RequestParam("appKey") String appKey);

    /**
     * 根据appkey获取每日的pv uv
     * @param appKey
     * @param startTime
     * @param endTime
     * @return
     */
    @RequestMapping("/data/adsmedia/getAppAllUvPvByDate")
    ResultModel<List<AppCount>> getAppAllUvPvByDate(@RequestParam("appKey") String appKey,
                                    @RequestParam("startTime") String startTime,
                                    @RequestParam("endTime") String endTime);

    /**
     * 根据appKey获取开发者所有广告位指定时间段内每一天的UV数量
     * @return
     */
    @RequestMapping("/data/adsmedia/getBusinessCountByDate")
    ResultModel<List<AppCount>> getBusinessCountByDate(@RequestBody SearchDataCommon searchDataCommon);

    /**
     * 获取一个日期内， UV大于0的所有广告位ID集合
     * @param dateStr
     * @return
     */
    @RequestMapping("/data/adsmedia/getEffectiveUVList")
    ResultModel<Set<String>> getEffectiveUVList(@RequestParam("date") String dateStr);

    /**
     * 获取一个日期内， 根据类型活广告位ID集合
     * @param dateStr
     * @param type  type=1 uv>=100  type=2 uv<100
     * @return
     */
    @RequestMapping("/data/adsmedia/getEffectiveUVListByType")
    ResultModel<Set<String>> getEffectiveUVListByType(@RequestParam("date") String dateStr,
                                                      @RequestParam(value = "type", defaultValue = "1") String type);
}
