package com.bxm.datapark.web;

import com.bxm.datapark.DataParkConstants;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ocpc.OcpcStatistics;
import com.bxm.datapark.facade.ocpc.OcpcStatisticsCondition;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * <h3>活动相关的数据</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2019/11/11 14:01
 */
@FeignClient(name = DataParkConstants.WEB_SERVICE)
public interface FacadeOcpcDataServive {

    @RequestMapping("/data/ticket/ocpc/find")
    public Page<OcpcStatistics> find(@RequestBody OcpcStatisticsCondition condition);
}
