package com.bxm.datapark.web;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import com.bxm.datapark.DataParkConstants;
import com.bxm.datapark.web.model.SspCreativeDaily;
import com.bxm.warcar.utils.response.ResultModel;

/**
 * <h3>SSP素材报表相关的数据</h3>
 *
 * @author zhengwangeng
 * @since 2020-06-18
 */
@FeignClient(name = DataParkConstants.WEB_SERVICE)
public interface FacadeSspCreativeDataServive {

    @RequestMapping("/data/ssp/creative")
    public ResultModel<List<SspCreativeDaily>> getCreativeData(@RequestBody SspCreativeDaily search);
}
