package com.bxm.datapark.web.model;

import java.io.Serializable;
import java.util.List;

/**
 * <h3>数据查询公共类</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2019/11/11 14:18
 */
public class SearchDataCommon implements Serializable {
    private static final long serialVersionUID = 8603702740176512921L;

    private String datetime;

    private String startTime;

    private String endTime;

    private String appKey;

    private List<String> appKeys;

    private String business;

    private List<String> businessList;

    public String getPostionId() {
        return postionId;
    }

    public void setPostionId(String postionId) {
        this.postionId = postionId;
    }

    private Long ticketId;

    private List<Long> ticketIdList;

    private String postionId;

    private String activityId;

    private List<String> postionIdList;

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public String getActivityId() {
        return activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public List<String> getAppKeys() {
        return appKeys;
    }

    public void setAppKeys(List<String> appKeys) {
        this.appKeys = appKeys;
    }

    public List<Long> getTicketIdList() {
        return ticketIdList;
    }

    public void setTicketIdList(List<Long> ticketIdList) {
        this.ticketIdList = ticketIdList;
    }

    public List<String> getBusinessList() {
        return businessList;
    }

    public void setBusinessList(List<String> businessList) {
        this.businessList = businessList;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public List<String> getPostionIdList() {
        return postionIdList;
    }

    public void setPostionIdList(List<String> postionIdList) {
        this.postionIdList = postionIdList;
    }

    public SearchDataCommon() {
    }

    public SearchDataCommon(Builder builder) {
        this.datetime = builder.datetime;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.appKey = builder.appKey;
        this.appKeys = builder.appKeys;
        this.business = builder.business;
        this.ticketId = builder.ticketId;
        this.postionId = builder.postionId;
        this.activityId = builder.activityId;
        this.ticketIdList = builder.ticketIdList;
        this.businessList = builder.businessList;
        this.postionIdList = builder.postionIdList;

    }
    public static class Builder{
        private String datetime;
        private String startTime;
        private String endTime;
        private String appKey;
        private List<String> appKeys;
        private String business;
        private Long ticketId;
        private String postionId;
        private String activityId;
        private List<Long> ticketIdList;
        private List<String> businessList;
        private List<String> postionIdList;

        public Builder datetime(String datetime) {
            this.datetime = datetime;
            return this;
        }

        public Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder appKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Builder appKeys(List<String> appKeys) {
            this.appKeys = appKeys;
            return this;
        }

        public Builder business(String business) {
            this.business = business;
            return this;
        }

        public Builder ticketId(Long ticketId) {
            this.ticketId = ticketId;
            return this;
        }

        public Builder postionId(String postionId) {
            this.postionId = postionId;
            return this;
        }

        public Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public Builder ticketIdList(List<Long> ticketIdList) {
            this.ticketIdList = ticketIdList;
            return this;
        }

        public Builder businessList(List<String> businessList) {
            this.businessList = businessList;
            return this;
        }

        public Builder postionIdList(List<String> postionIdList) {
            this.postionIdList = postionIdList;
            return this;
        }


        public SearchDataCommon build(){
            return new SearchDataCommon(this);
        }
    }

    public static SearchDataCommon.Builder builder(){
        return new SearchDataCommon.Builder();
    }
}
