package com.bxm.datapark.web.model;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 点石成金广告位财务报表
 * </p>
 *
 * @author hcmony
 * @since 2020-01-11
 */

public class SspPositionFinanceDaily implements Serializable {

    private String datetime;

    /**
     * 广告位id标识
     */
    private String positionId;

    /**
     * 应用ID
     */
    private Long appId;

    private Long dspId;
    /**
     * 开发者id
     */
    private Long developerId;

    /**
     * 媒体端请求到变现猫的请求量
     */
    private Integer requestPv;

    /**
     * 广告真实在广告位上曝光的数量
     */
    private Integer exposurePv;

    /**
     * 广告真实在广告位上点击的数量
     */
    private Integer clickPv;

    /**
     * 广告端竞价收入，单位：元
     */
    private BigDecimal bidIncome;

    private Integer requestUv;

    public Integer getRequestUv() {
        return requestUv;
    }

    public void setRequestUv(Integer requestUv) {
        this.requestUv = requestUv;
    }

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getDspId() {
        return dspId;
    }

    public void setDspId(Long dspId) {
        this.dspId = dspId;
    }

    public Long getDeveloperId() {
        return developerId;
    }

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    public Integer getRequestPv() {
        return requestPv;
    }

    public void setRequestPv(Integer requestPv) {
        this.requestPv = requestPv;
    }

    public Integer getExposurePv() {
        return exposurePv;
    }

    public void setExposurePv(Integer exposurePv) {
        this.exposurePv = exposurePv;
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public BigDecimal getBidIncome() {
        return bidIncome;
    }

    public void setBidIncome(BigDecimal bidIncome) {
        this.bidIncome = bidIncome;
    }
}
